/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.report.ExternalResults;
import org.openvpms.laboratory.resource.Content;
import org.openvpms.laboratory.resource.Resource;
import org.openvpms.laboratory.resource.Resources;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.laboratory.service.Orders;
import org.openvpms.web.component.im.doc.DocumentActTableModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.IMObjectSelections;
import org.openvpms.web.component.im.query.MultiSelectBrowser;
import org.openvpms.web.component.im.query.MultiSelectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.TabbedBrowser;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.mail.AttachmentBrowser;
import org.openvpms.web.component.mail.ContentAttachment;
import org.openvpms.web.component.mail.MailAttachment;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.document.ActAttachmentBrowser;
import org.openvpms.web.workspace.customer.document.CustomerDocumentQuery;
import org.openvpms.web.workspace.customer.document.ExternalDocumentsDialog;
import org.openvpms.web.workspace.customer.document.ResourceIteratorResultSet;
import org.openvpms.web.workspace.patient.mr.PatientDocumentQuery;

public abstract class AbstractCustomerPatientDocumentBrowser
extends TabbedBrowser<MailAttachment>
implements AttachmentBrowser {
    private final Party customer;
    private final Party patient;
    private final boolean customerFirst;
    private final Date from;
    private final Date to;
    private final LayoutContext context;
    private final IArchetypeService service;
    private final List<MailAttachment> externalDocuments = new ArrayList<MailAttachment>();
    private static final String DOCUMENT_TEMPLATE = "documentTemplate";

    public AbstractCustomerPatientDocumentBrowser(Party customer, Party patient, boolean customerFirst, Date from, Date to, LayoutContext context) {
        this.customer = customer;
        this.patient = patient;
        this.customerFirst = customerFirst;
        this.from = from;
        this.to = to;
        this.context = context;
        this.service = ServiceHelper.getArchetypeService();
    }

    public Component getComponent() {
        if (this.getBrowsers().isEmpty()) {
            if (this.customerFirst) {
                this.addCustomerBrowsers();
                this.addPatientBrowsers();
            } else {
                this.addPatientBrowsers();
                this.addCustomerBrowsers();
            }
        }
        return super.getComponent();
    }

    public Collection<MailAttachment> getSelections() {
        ArrayList<MailAttachment> result = new ArrayList<MailAttachment>();
        for (Browser browser : this.getBrowsers()) {
            if (!(browser instanceof MultiSelectBrowser)) continue;
            result.addAll(((MultiSelectBrowser)browser).getSelections());
        }
        result.addAll(this.externalDocuments);
        return result;
    }

    public void clearSelections() {
        for (Browser browser : this.getBrowsers()) {
            if (!(browser instanceof MultiSelectBrowser)) continue;
            ((MultiSelectBrowser)browser).clearSelections();
        }
        this.externalDocuments.clear();
    }

    protected void addCustomerBrowsers() {
        if (this.customer != null) {
            this.addCustomerBrowsers(this.customer, this.patient);
        }
    }

    protected void addCustomerBrowsers(Party customer, Party patient) {
        this.addDocumentBrowser("customer.documentbrowser.customer", new CustomerDocumentQuery<Act>(customer), null);
    }

    protected void addPatientBrowsers() {
        if (this.patient != null) {
            this.addPatientBrowsers(this.patient);
        }
    }

    protected void addPatientBrowsers(Party patient) {
        PatientDocumentModel model = new PatientDocumentModel(this.context);
        this.addDocumentBrowser("customer.documentbrowser.patient", new PatientDocumentQuery<Act>(patient), (IMObjectTableModel<Act>)model);
    }

    protected void addDocumentBrowser(String key, DateRangeActQuery<Act> query, IMObjectTableModel<Act> model) {
        this.init(query);
        IMObjectSelections<Act> selections = new IMObjectSelections<Act>(){

            public boolean canSelect(Act object) {
                return AbstractCustomerPatientDocumentBrowser.this.canSelectDocument(object);
            }
        };
        DocumentBrowser browser = model != null ? new DocumentBrowser((Query<Act>)query, (IMTableModel<Act>)model, (MultiSelectTableBrowser.SelectionTracker<Act>)selections, this.context) : new DocumentBrowser((Query<Act>)query, (MultiSelectTableBrowser.SelectionTracker<Act>)selections, this.context);
        this.addBrowser(Messages.get((String)key), (Browser)new ActAttachmentBrowser((MultiSelectBrowser<Act>)browser));
    }

    protected void addBrowser(String key, DateRangeActQuery<Act> query) {
        this.init(query);
        this.addBrowser(Messages.get((String)key), (Browser)new ActAttachmentBrowser((MultiSelectBrowser<Act>)new MultiSelectTableBrowser(query, this.context)));
    }

    protected void addBrowser(String key, DateRangeActQuery<Act> query, IMObjectTableModel<Act> model) {
        this.init(query);
        this.addBrowser(Messages.get((String)key), (Browser)new ActAttachmentBrowser((MultiSelectBrowser<Act>)new MultiSelectTableBrowser(query, model, this.context)));
    }

    protected void init(DateRangeActQuery<Act> query) {
        if (this.from != null || this.to != null) {
            query.getComponent();
            query.setAllDates(false);
            query.setFrom(this.from);
            query.setTo(this.to);
        }
    }

    protected void addResources(Collection<Resource> resources) {
        ContentAttachment attachment = null;
        for (Resource resource : resources) {
            if (!(resource instanceof Content)) continue;
            attachment = new ContentAttachment((Content)resource);
            this.externalDocuments.add((MailAttachment)attachment);
        }
        if (attachment != null) {
            this.notifyBrowsed(attachment);
        }
    }

    protected boolean canSelectDocument(Act act) {
        boolean result = false;
        if (act instanceof DocumentAct) {
            IMObjectBean bean;
            DocumentAct documentAct = (DocumentAct)act;
            result = documentAct.getDocument() != null ? true : (act.isA("act.patientInvestigation") ? true : (bean = this.service.getBean((IMObject)documentAct)).hasNode(DOCUMENT_TEMPLATE) && bean.getTargetRef(DOCUMENT_TEMPLATE) != null);
        }
        return result;
    }

    protected LayoutContext getContext() {
        return this.context;
    }

    private class DocumentBrowser
    extends MultiSelectTableBrowser<Act> {
        public DocumentBrowser(Query<Act> query, MultiSelectTableBrowser.SelectionTracker<Act> tracker, LayoutContext context) {
            super(query, tracker, context);
        }

        public DocumentBrowser(Query<Act> query, IMTableModel<Act> model, MultiSelectTableBrowser.SelectionTracker<Act> tracker, LayoutContext context) {
            super(query, model, tracker, context);
        }

        protected void notifySelectionDisabled(Act object) {
            InformationDialog.show((String)Messages.format((String)"document.attachment.nocontent", (Object[])new Object[]{DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)AbstractCustomerPatientDocumentBrowser.this.service)}));
        }
    }

    class PatientDocumentModel
    extends DocumentActTableModel {
        public PatientDocumentModel(LayoutContext context) {
            super(context);
        }

        protected Component createDocumentViewer(DocumentAct act) {
            Component component = super.createDocumentViewer(act);
            if (act.isA("act.patientInvestigation")) {
                try {
                    Component external = this.getExternalResults(act);
                    if (external != null) {
                        component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{component, external});
                    }
                }
                catch (Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            }
            return component;
        }

        private Component getExternalResults(DocumentAct act) {
            Resources documents;
            ResourceIteratorResultSet set;
            Orders orders;
            LaboratoryServices services;
            LaboratoryService service;
            ExternalResults results;
            Entity laboratory;
            Button result = null;
            IMObjectBean bean = this.getBean((IMObject)act);
            if (bean.getBoolean("externalResults") && (laboratory = (Entity)this.getContext().getCache().get(bean.getTargetRef("laboratory"))) != null && (results = (service = (services = (LaboratoryServices)ServiceHelper.getBean(LaboratoryServices.class)).getService(laboratory)).getExternalResults((orders = (Orders)ServiceHelper.getBean(Orders.class)).getOrder(act.getId()))).hasDocuments() && (set = new ResourceIteratorResultSet(documents = results.getDocuments(), 5)).hasNext()) {
                Button button = ButtonFactory.create(null, (String)"attach", () -> this.showExternalDocuments(set));
                button.setToolTipText(Messages.get((String)"document.attachexternal"));
                result = button;
            }
            return result;
        }

        private void showExternalDocuments(ResourceIteratorResultSet set) {
            final ExternalDocumentsDialog dialog = new ExternalDocumentsDialog(set, this.getContext().getHelpContext());
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    Collection<Resource> selected = dialog.getSelected();
                    if (!selected.isEmpty()) {
                        AbstractCustomerPatientDocumentBrowser.this.addResources(selected);
                    }
                }
            });
            dialog.show();
        }
    }
}

