/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.credit;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.insurance.claim.Claim;
import org.openvpms.insurance.claim.GapClaim;
import org.openvpms.insurance.internal.claim.GapClaimImpl;

public class GapClaimAllocation {
    private final GapClaimImpl claim;
    private final FinancialAct act;
    private final BigDecimal allocation;
    private final BigDecimal existingAllocation;
    private final BigDecimal newAllocation;
    private final Status status;
    private Entity till;

    public GapClaimAllocation(GapClaimImpl claim, FinancialAct act, BigDecimal existingAllocation, BigDecimal newAllocation, Entity till) {
        BigDecimal gapAmount;
        int compareTo;
        this.claim = claim;
        this.act = act;
        this.allocation = existingAllocation.add(newAllocation);
        this.existingAllocation = existingAllocation;
        this.newAllocation = newAllocation;
        this.till = till;
        this.status = this.benefitPending() ? (this.allocation.compareTo(claim.getTotal()) < 0 ? Status.NO_BENEFIT_PARTIAL_PAYMENT : Status.NO_BENEFIT_FULL_PAYMENT) : ((compareTo = this.allocation.compareTo(gapAmount = claim.getGapAmount())) < 0 ? Status.ALLOCATION_LESS_THAN_GAP : (compareTo == 0 ? Status.ALLOCATION_EQUAL_TO_GAP : (claim.getStatus() == Claim.Status.PRE_SETTLED ? Status.PRE_SETTLED_AND_ALLOCATION_GREATER_THAN_GAP : (this.allocation.compareTo(claim.getTotal()) < 0 ? Status.ALLOCATION_GREATER_THAN_GAP : Status.FULL_PAYMENT))));
    }

    public BigDecimal getTotal() {
        return this.claim.getTotal();
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isPresettledAndAllocationIsGreaterThanGap() {
        return this.status == Status.PRE_SETTLED_AND_ALLOCATION_GREATER_THAN_GAP;
    }

    public BigDecimal getAllocation() {
        return this.allocation;
    }

    public BigDecimal getExistingAllocation() {
        return this.existingAllocation;
    }

    public BigDecimal getNewAllocation() {
        return this.newAllocation;
    }

    public boolean isAllocated() {
        return !MathRules.isZero((BigDecimal)this.allocation);
    }

    public BigDecimal getGapAmount() {
        return this.claim.getGapAmount();
    }

    public BigDecimal getUnpaidGap() {
        return this.getGapAmount().subtract(this.existingAllocation);
    }

    public GapClaimImpl getClaim() {
        return this.claim;
    }

    public FinancialAct getAct() {
        return this.act;
    }

    public Party getInsurer() {
        return this.claim.getInsurer();
    }

    public boolean benefitPending() {
        return this.claim.getGapStatus() == GapClaim.GapStatus.PENDING;
    }

    public FinancialAct gapPaid(Party location) {
        return this.claim.gapPaid(this.till, location);
    }

    public boolean isTillRequired() {
        return this.status == Status.ALLOCATION_EQUAL_TO_GAP;
    }

    public void setTill(Entity till) {
        this.till = till;
    }

    public Entity getTill() {
        return this.till;
    }

    public void fullyPaid() {
        this.claim.fullyPaid();
    }

    public static enum Status {
        NO_BENEFIT_PARTIAL_PAYMENT,
        NO_BENEFIT_FULL_PAYMENT,
        ALLOCATION_LESS_THAN_GAP,
        ALLOCATION_EQUAL_TO_GAP,
        PRE_SETTLED_AND_ALLOCATION_GREATER_THAN_GAP,
        ALLOCATION_GREATER_THAN_GAP,
        FULL_PAYMENT;

    }
}

