/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.AbstractListComponent;
import nextapp.echo2.app.list.ListCellRenderer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.list.StyledListCell;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.workspace.alert.AbstractAlertActEditor;
import org.openvpms.web.workspace.alert.AlertLayoutStrategy;

public class CustomerAlertActEditor
extends AbstractAlertActEditor {
    private final TextField priority;
    private final SelectField alertType;

    public CustomerAlertActEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        this.initParticipant("customer", (IMObject)context.getContext().getCustomer());
        this.priority = TextComponentFactory.create();
        Property property = this.getProperty("alertType");
        this.alertType = LookupFieldFactory.create((Property)property, (IMObject)act);
        this.alertType.setCellRenderer((ListCellRenderer)new AlertTypeCellRenderer());
        this.refreshAlertType();
        property.addModifiableListener(modifiable -> this.refreshAlertType());
    }

    public Lookup getAlertType() {
        LookupListModel model = (LookupListModel)this.alertType.getModel();
        int index = this.alertType.getSelectedIndex();
        return index != -1 ? model.getLookup(index) : null;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        AlertLayoutStrategy strategy = new AlertLayoutStrategy(this.priority);
        strategy.addComponent(new ComponentState((Component)this.alertType, this.getProperty("alertType")));
        return strategy;
    }

    private void refreshAlertType() {
        Lookup lookup = this.getAlertType();
        if (lookup != null) {
            Alert alert = new Alert((IMObject)lookup);
            Color background = alert.getColour();
            Color foreground = alert.getTextColour();
            this.alertType.setBackground(background);
            this.alertType.setForeground(foreground);
            this.priority.setText(alert.getPriority().getName());
        } else {
            this.priority.setText("");
        }
    }

    private static class AlertTypeCellRenderer
    extends LookupListCellRenderer {
        private AlertTypeCellRenderer() {
        }

        protected Object getComponent(Component list, String object, int index) {
            AbstractListComponent l = (AbstractListComponent)list;
            LookupListModel model = (LookupListModel)l.getModel();
            Lookup lookup = model.getLookup(index);
            Alert alert = new Alert((IMObject)lookup);
            Color background = alert.getColour();
            Color foreground = alert.getTextColour();
            return new StyledListCell(lookup.getName(), background, foreground);
        }
    }
}

