/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.StringUtilities;
import org.openvpms.web.component.im.doc.HtmlToTextFormatter;
import org.openvpms.web.component.im.util.IMObjectCreator;

public class CommunicationLogger {
    private final ArchetypeService service;
    private final TextDocumentHandler handler;

    public CommunicationLogger(ArchetypeService service) {
        this.service = service;
        this.handler = new TextDocumentHandler(service);
    }

    public void logEmail(Party customer, Party patient, String from, String[] to, String[] cc, String[] bcc, String subject, String reason, String message, String note, String attachments, Party location) {
        if (message != null) {
            HtmlToTextFormatter formatter = new HtmlToTextFormatter();
            message = formatter.format(message);
        }
        IMObjectBean bean = this.createLog("act.customerCommunicationEmail", customer, patient, this.getAddresses(to), subject, reason, note, location);
        this.setValue(bean, "from", from);
        bean.setValue("cc", (Object)this.getAddresses(cc));
        bean.setValue("bcc", (Object)this.getAddresses(bcc));
        this.setValue(bean, "attachments", attachments);
        this.saveLog(message, bean, "email.txt");
    }

    public void logMail(Party customer, Party patient, String address, String subject, String reason, String message, String note, Party location) {
        IMObjectBean bean = this.createLog("act.customerCommunicationMail", customer, patient, address, subject, reason, note, location);
        this.saveLog(message, bean, "mail.txt");
    }

    public void logPhone(Party customer, Party patient, String phoneNumber, String subject, String reason, String message, String note, Party location) {
        IMObjectBean bean = this.createLog("act.customerCommunicationPhone", customer, patient, phoneNumber, subject, reason, note, location);
        this.saveLog(message, bean, "phone.txt");
    }

    protected void saveLog(String message, IMObjectBean bean, String fileName) {
        int length = this.getLength(bean, "message");
        if (message != null && message.length() > length) {
            Document document = this.handler.create(fileName, message);
            bean.setValue("document", (Object)document.getObjectReference());
            if (bean.hasNode("mimeType")) {
                bean.setValue("mimeType", (Object)document.getMimeType());
            }
            if (bean.hasNode("fileName")) {
                bean.setValue("fileName", (Object)document.getName());
            }
            bean.save(new IMObject[]{document});
        } else {
            this.setValue(bean, "message", message);
            bean.save();
        }
    }

    protected IMObjectBean createLog(String shortName, Party customer, Party patient, String address, String subject, String reason, String note, Party location) {
        Act act = (Act)IMObjectCreator.create((String)shortName);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("customer", (IMObject)customer);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("location", (IMObject)location);
        this.setValue(bean, "address", address);
        this.setValue(bean, "description", subject);
        bean.setValue("reason", (Object)reason);
        this.setValue(bean, "note", note);
        return bean;
    }

    protected String getAddresses(String[] addresses) {
        String result = null;
        if (addresses != null) {
            result = StringUtils.join((Object[])addresses, (String)"\n");
            result = StringUtils.abbreviate((String)result, (int)5000);
        }
        return result;
    }

    protected void setValue(IMObjectBean bean, String name, String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            value = this.removeEmojis(value);
            bean.setValue(name, (Object)StringUtils.abbreviate((String)value, (int)this.getLength(bean, name)));
        }
    }

    private int getLength(IMObjectBean bean, String name) {
        int length = bean.getMaxLength(name);
        if (length == -1) {
            length = 255;
        }
        return length;
    }

    private String removeEmojis(String message) {
        return StringUtilities.replace4ByteUnicode((String)message);
    }
}

