/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMObjectTable;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.DelegatingProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.workspace.customer.communication.AbstractCommunicationLayoutStrategy;

public class CommunicationLayoutStrategy
extends AbstractCommunicationLayoutStrategy {
    private final String contacts;

    public CommunicationLayoutStrategy() {
        this(null, null, true);
    }

    public CommunicationLayoutStrategy(Property message, String contacts, boolean showPatient) {
        super(showPatient, message, "startTime");
        this.contacts = contacts;
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Party customer;
        if (!context.isEdit()) {
            this.addContactViewers(properties, object, context);
        } else if (this.contacts != null && (customer = (Party)this.getBean(object).getTarget("customer", Party.class)) != null) {
            this.addContactEditors(object, properties, customer, context);
        }
        return super.apply(object, properties, parent, context);
    }

    protected void addContactViewers(PropertySet properties, IMObject object, LayoutContext context) {
        Property address = properties.get("address");
        if (address != null) {
            this.addContactViewer(address, object, context, false);
        }
    }

    protected void addContactViewer(Property property, IMObject object, LayoutContext context, boolean optional) {
        String value = property.getString();
        if (!optional || !StringUtils.isEmpty((CharSequence)value)) {
            ComponentState state;
            int lines = StringUtils.countMatches((CharSequence)value, (CharSequence)"\n") + 1;
            if (lines > 1) {
                state = this.createComponent(property, object, context);
                Component component = state.getComponent();
                if (component instanceof TextArea) {
                    TextArea text = (TextArea)component;
                    text.setHeight(new Extent(lines + 1, 64));
                }
            } else {
                DelegatingProperty p = new DelegatingProperty(property){

                    public int getMaxLength() {
                        return 255;
                    }
                };
                state = this.createComponent((Property)p, object, context);
            }
            this.addComponent(state);
        }
    }

    protected void addContactEditors(IMObject object, PropertySet properties, Party customer, LayoutContext context) {
        Property address = properties.get("address");
        if (address != null) {
            this.addContactSelector(address, object, customer, context);
        }
    }

    protected void addContactSelector(Property property, IMObject object, Party customer, LayoutContext context) {
        List<Contact> contacts = this.getContacts(customer);
        this.addContactSelector(property, object, contacts, context);
    }

    protected void addContactSelector(final Property property, IMObject object, List<Contact> contacts, LayoutContext context) {
        IMObjectComponentFactory factory = context.getComponentFactory();
        ComponentState address = factory.create(property, object);
        Component addressComponent = address.getComponent();
        if (addressComponent instanceof TextArea) {
            ((TextArea)addressComponent).setHeight(new Extent(2, 64));
        }
        if (!contacts.isEmpty()) {
            final DropDown contactDropDown = new DropDown();
            final IMObjectTable table = new IMObjectTable();
            table.setObjects(contacts);
            table.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    Contact contact = (Contact)table.getSelected();
                    if (contact != null) {
                        property.setValue((Object)CommunicationLayoutStrategy.this.formatContact(contact));
                    }
                    contactDropDown.setExpanded(false);
                }
            });
            contactDropDown.setTarget(addressComponent);
            contactDropDown.setPopUpAlwaysOnTop(true);
            contactDropDown.setFocusOnExpand(true);
            contactDropDown.setPopUp((Component)table);
            contactDropDown.setFocusComponent((Component)table);
            this.addComponent(new ComponentState((Component)contactDropDown, property));
        } else {
            this.addComponent(address);
        }
    }

    protected String formatContact(Contact contact) {
        return contact.getDescription();
    }

    protected List<Contact> getContacts(Party party) {
        ArrayList<Contact> result = new ArrayList<Contact>();
        for (Contact contact : party.getContacts()) {
            if (!contact.isA(this.contacts)) continue;
            result.add(contact);
        }
        return result;
    }
}

