/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge.department;

import java.util.Collections;
import java.util.List;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.edit.ComboBoxIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public class DepartmentReferenceEditor
extends ComboBoxIMObjectReferenceEditor<Entity> {
    private List<Entity> departments;

    public DepartmentReferenceEditor(Property property, IMObject parent, LayoutContext context) {
        super(property, context);
    }

    protected List<Entity> getObjects() {
        if (this.departments == null) {
            UserRules rules = (UserRules)ServiceHelper.getBean(UserRules.class);
            User user = this.getContext().getContext().getUser();
            this.departments = user != null ? rules.getDepartments(user) : Collections.emptyList();
        }
        return this.departments;
    }

    protected boolean updateProperty(Entity value) {
        boolean result = super.updateProperty((IMObject)value);
        this.updateContext(value);
        return result;
    }

    private void updateContext(Entity department) {
        if (department == null || department.isActive() && this.getObjects().contains(department)) {
            this.getContext().getContext().setDepartment(department);
        }
    }
}

