/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.discount.DiscountRules;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.CachingReadOnlyArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingContext;
import org.openvpms.web.component.im.product.PricingContextFactory;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.mr.DoseManager;

public class PriceActEditContext {
    private final Party practice;
    private final Party location;
    private final IArchetypeService service;
    private final CustomerTaxRules taxRules;
    private final LocationRules locationRules;
    private final CustomerAccountRules accountRules;
    private final DiscountRules discountRules;
    private final StockRules stockRules;
    private final boolean useDepartments;
    private final boolean disableDiscounts;
    private final boolean useLocationProducts;
    private final boolean useMinimumQuantities;
    private final boolean overrideMinimumQuantity;
    private final boolean sellRestrictedDrugsOTC;
    private final PricingContext pricingContext;
    private DoseManager doseManager;

    public PriceActEditContext(Party customer, Party location, LayoutContext context) {
        this.practice = context.getContext().getPractice();
        if (this.practice == null) {
            throw new IllegalStateException("Context is missing the practice");
        }
        this.location = location;
        this.service = new CachingReadOnlyArchetypeService(context.getCache(), (IArchetypeService)ServiceHelper.getArchetypeService());
        PracticeRules practiceRules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
        this.disableDiscounts = this.getDisableDiscounts(location);
        this.useLocationProducts = practiceRules.useLocationProducts(this.practice);
        IMObjectBean bean = this.service.getBean((IMObject)this.practice);
        this.useMinimumQuantities = bean.getBoolean("minimumQuantities", false);
        if (this.useMinimumQuantities) {
            User user = context.getContext().getUser();
            String userType = bean.getString("minimumQuantitiesOverride");
            this.overrideMinimumQuantity = userType != null && ((UserRules)ServiceHelper.getBean(UserRules.class)).isA(user, userType);
        } else {
            this.overrideMinimumQuantity = false;
        }
        this.useDepartments = practiceRules.departmentsEnabled(this.practice);
        this.sellRestrictedDrugsOTC = bean.getBoolean("sellRestrictedDrugsOTC");
        this.accountRules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        this.locationRules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
        ProductPriceRules priceRules = new ProductPriceRules((ArchetypeService)this.service);
        this.taxRules = new CustomerTaxRules(this.practice, this.service);
        this.discountRules = new DiscountRules(this.service);
        this.stockRules = new StockRules(this.service);
        PricingContextFactory factory = (PricingContextFactory)ServiceHelper.getBean(PricingContextFactory.class);
        this.pricingContext = factory.createCustomerPricingContext(customer, this.practice, location, priceRules, this.taxRules);
    }

    public void setDoseManager(DoseManager doseManager) {
        this.doseManager = doseManager;
    }

    public DoseManager getDoseManager() {
        return this.doseManager;
    }

    public PricingContext getPricingContext() {
        return this.pricingContext;
    }

    public BigDecimal getPrice(Product product, ProductPrice price, BigDecimal serviceRatio) {
        return this.pricingContext.getPrice(product, price, serviceRatio);
    }

    public BigDecimal getDose(Product product, Party patient) {
        return this.doseManager != null ? this.doseManager.getDose(product, patient) : BigDecimal.ZERO;
    }

    public Party getLocation() {
        return this.location;
    }

    public Party getStockLocation() {
        return this.location != null ? this.locationRules.getDefaultStockLocation(this.location) : null;
    }

    public Party getStockLocation(Product product) {
        return this.location != null ? this.stockRules.getStockLocation(product, this.location) : null;
    }

    public IArchetypeService getCachingArchetypeService() {
        return this.service;
    }

    public Party getPractice() {
        return this.practice;
    }

    public DiscountRules getDiscountRules() {
        return this.discountRules;
    }

    public CustomerTaxRules getTaxRules() {
        return this.taxRules;
    }

    public StockRules getStockRules() {
        return this.stockRules;
    }

    public boolean useDepartments() {
        return this.useDepartments;
    }

    public boolean disableDiscounts() {
        return this.disableDiscounts;
    }

    public boolean useLocationProducts() {
        return this.useLocationProducts;
    }

    public boolean useMinimumQuantities() {
        return this.useMinimumQuantities;
    }

    public boolean overrideMinimumQuantities() {
        return this.overrideMinimumQuantity;
    }

    public boolean sellRestrictedDrugsOTC() {
        return this.sellRestrictedDrugsOTC;
    }

    public BigDecimal calculateTotal(BigDecimal fixedPrice, BigDecimal unitPrice, BigDecimal quantity, BigDecimal discount) {
        return this.accountRules.calculateTotal(fixedPrice, unitPrice, quantity, discount);
    }

    private boolean getDisableDiscounts(Party location) {
        boolean result = false;
        if (location != null) {
            IMObjectBean bean = this.service.getBean((IMObject)location);
            result = bean.getBoolean("disableDiscounts");
        }
        return result;
    }
}

