/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.hl7.laboratory.LaboratoryOrderService;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.hl7.pharmacy.PharmacyOrderService;
import org.openvpms.laboratory.internal.dispatcher.OrderDispatcher;
import org.openvpms.web.workspace.customer.charge.OrderServices;
import org.openvpms.web.workspace.customer.charge.PharmacyProducts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderPlacer {
    private final Party customer;
    private final Party location;
    private final User user;
    private final IMObjectCache cache;
    private final OrderServices services;
    private final ArchetypeService service;
    private final PharmacyProducts pharmacies;
    private final boolean discontinueOnFinalisation;
    private final Map<Reference, Order> orders = new HashMap<Reference, Order>();
    private static final Logger log = LoggerFactory.getLogger(OrderPlacer.class);

    public OrderPlacer(Party customer, Party location, User user, Party practice, IMObjectCache cache, OrderServices services, ArchetypeService service) {
        this.customer = customer;
        this.location = location;
        this.user = user;
        this.cache = cache;
        this.services = services;
        this.service = service;
        PracticeRules rules = services.getPracticeRules();
        Period period = rules.getPharmacyOrderDiscontinuePeriod(practice);
        this.discontinueOnFinalisation = period == null || period.toStandardDuration().compareTo((ReadableDuration)Duration.ZERO) < 0;
        this.pharmacies = new PharmacyProducts(services.getPharmacies(), location, cache);
    }

    public void initialise(List<Act> items) {
        for (Act item : items) {
            this.initialise(item);
        }
    }

    public void initialise(Act item) {
        Order order = this.getOrder(item);
        if (order != null) {
            this.orders.put(item.getObjectReference(), order);
        }
    }

    public Set<Act> order(List<Act> items, PatientHistoryChanges changes) {
        return this.order(items, Collections.emptyList(), changes);
    }

    public Set<Act> order(List<Act> items, List<Act> excluded, PatientHistoryChanges changes) {
        Map<Reference, Act> invoiceItemsByRef = this.getInvoiceItems(items);
        ArrayList<Reference> ids = new ArrayList<Reference>(this.orders.keySet());
        HashSet<Act> updated = new HashSet<Act>();
        HashSet<Party> patients = new HashSet<Party>();
        for (Act item : items) {
            List<Act> invoiceItems = this.getInvoiceItems(item, invoiceItemsByRef);
            Reference id = item.getObjectReference();
            ids.remove(id);
            Order order = this.getOrder(item);
            Order existing = this.orders.get(id);
            if (order != null) {
                if (existing != null && existing.isPlaced()) {
                    existing.verifyOrder(order);
                    if (!existing.needsUpdate(order) || !this.updateOrder(order, invoiceItems, changes, patients, updated)) continue;
                    this.orders.put(id, order);
                    continue;
                }
                if (order.isPlaced() || !this.createOrder(order, invoiceItems, changes, patients, updated)) continue;
                this.orders.put(id, order);
                continue;
            }
            if (existing == null) continue;
            this.cancelOrder(existing, changes, patients, updated);
        }
        for (Act exclude : excluded) {
            ids.remove(exclude.getObjectReference());
        }
        for (Reference id : ids) {
            Order existing = this.orders.remove(id);
            this.cancelOrder(existing, changes, patients, updated);
        }
        return updated;
    }

    public Set<Act> cancel() {
        HashSet<Act> updated = new HashSet<Act>();
        HashMap<Reference, Act> events = new HashMap<Reference, Act>();
        for (Order order : this.orders.values()) {
            if (!order.isPlaced()) continue;
            PatientContext context = this.getPatientContext(order, events);
            if (context != null) {
                order.cancel(context, this.services, this.user, updated);
                continue;
            }
            log.warn("Cannot cancel order due to missing visit: {}", (Object)order);
        }
        return updated;
    }

    public Set<Act> cancelDeleted(List<Act> current, PatientHistoryChanges changes) {
        HashSet<Act> updated = new HashSet<Act>();
        HashMap<Reference, Order> copy = new HashMap<Reference, Order>(this.orders);
        for (Act act : current) {
            copy.remove(act.getObjectReference());
        }
        if (!copy.isEmpty()) {
            HashSet<Party> patients = new HashSet<Party>();
            for (Map.Entry removed : copy.entrySet()) {
                this.cancelOrder((Order)removed.getValue(), changes, patients, updated);
                this.orders.remove(removed.getKey());
            }
        }
        return updated;
    }

    public Set<Act> discontinue(List<Act> items) {
        HashSet<Act> updated = new HashSet<Act>();
        Map<Reference, Act> invoiceItems = this.getInvoiceItems(items);
        Map<Reference, List<Act>> ordersToInvoiceItems = this.getOrdersToInvoices(items, invoiceItems);
        HashMap<Reference, Act> events = new HashMap<Reference, Act>();
        for (Map.Entry<Reference, Order> entry : this.orders.entrySet()) {
            Reference id;
            List<Act> itemsForOrder;
            PatientContext context;
            Order order = entry.getValue();
            if (order instanceof PharmacyOrder && (context = this.getPatientContext(order, events)) != null) {
                order.discontinue(context, this.services, this.user);
            }
            if ((itemsForOrder = ordersToInvoiceItems.get(id = entry.getKey())) == null) continue;
            for (Act itemForOrder : itemsForOrder) {
                if (!"ORDERED".equals(itemForOrder.getStatus())) continue;
                itemForOrder.setStatus("DISCONTINUED");
                updated.add(itemForOrder);
            }
        }
        return updated;
    }

    public boolean isPharmacyProduct(Product product) {
        return product != null && this.getPharmacy(product) != null;
    }

    public boolean discontinueOnFinalisation() {
        return this.discontinueOnFinalisation;
    }

    private Map<Reference, List<Act>> getOrdersToInvoices(List<Act> items, Map<Reference, Act> invoiceItems) {
        HashMap<Reference, List<Act>> result = new HashMap<Reference, List<Act>>();
        for (Act item : items) {
            if (item.isA("act.customerAccountInvoiceItem")) {
                result.put(item.getObjectReference(), Collections.singletonList(item));
                continue;
            }
            result.put(item.getObjectReference(), this.getInvoiceItems(item, invoiceItems));
        }
        return result;
    }

    private List<Act> getInvoiceItems(Act act, Map<Reference, Act> invoiceItems) {
        List<Act> result;
        if (act.isA("act.customerAccountInvoiceItem")) {
            result = Collections.singletonList(act);
        } else {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            List references = bean.getSourceRefs("invoiceItems");
            if (references.isEmpty()) {
                throw new IllegalStateException("No invoice item found for " + act);
            }
            result = new ArrayList<Act>();
            for (Reference reference : references) {
                Act item = invoiceItems.get(reference);
                if (item == null) {
                    throw new IllegalStateException("No invoice item found for " + act);
                }
                result.add(item);
            }
        }
        return result;
    }

    private Map<Reference, Act> getInvoiceItems(List<Act> items) {
        HashMap<Reference, Act> result = new HashMap<Reference, Act>();
        for (Act item : items) {
            if (!item.isA("act.customerAccountInvoiceItem")) continue;
            result.put(item.getObjectReference(), item);
        }
        return result;
    }

    private Order getOrder(Act act) {
        Order result = null;
        if (act.isA("act.customerAccountInvoiceItem")) {
            result = this.getPharmacyOrder(act);
        } else if (act.isA("act.patientInvestigation")) {
            result = this.getLaboratory(act);
        }
        return result;
    }

    private Order getPharmacyOrder(Act act) {
        Party patient;
        Entity pharmacy;
        PharmacyOrder order = null;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Product product = (Product)this.getObject(bean.getTargetRef("product"));
        if (product != null && product.isA(new String[]{"product.medication", "product.merchandise"}) && (pharmacy = this.getPharmacy(product)) != null && (patient = (Party)this.getObject(bean.getTargetRef("patient"))) != null) {
            BigDecimal quantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
            User clinician = (User)this.getObject(bean.getTargetRef("clinician"));
            Reference event = bean.getSourceRef("event");
            order = new PharmacyOrder(act, product, patient, quantity, clinician, pharmacy, event, this.service);
        }
        return order;
    }

    private Order getLaboratory(Act act) {
        Order order = null;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Entity investigationType = (Entity)this.getObject(bean.getTargetRef("investigationType"));
        if (investigationType != null) {
            Party patient;
            Entity laboratory = (Entity)this.getObject(bean.getTargetRef("laboratory"));
            if (laboratory == null) {
                laboratory = this.getLaboratory(investigationType);
            }
            if (laboratory != null && (patient = (Party)this.getObject(bean.getTargetRef("patient"))) != null) {
                User clinician = (User)this.getObject(bean.getTargetRef("clinician"));
                Reference event = bean.getSourceRef("event");
                if (laboratory.isA("entity.HL7ServiceLaboratory")) {
                    Entity test = (Entity)this.getObject(bean.getTargetRef("tests"));
                    if (test != null) {
                        String testCode;
                        IMObjectBean testBean = this.service.getBean((IMObject)test);
                        Identity identity = (Identity)testBean.getObject("code", Identity.class);
                        String string = testCode = identity != null ? identity.getIdentity() : null;
                        if (testCode != null) {
                            order = new HL7LaboratoryOrder(act, testCode, patient, clinician, laboratory, event);
                        }
                    }
                } else {
                    order = new LaboratoryOrder(act, patient, clinician, laboratory, event);
                }
            }
        }
        return order;
    }

    private PatientContext getPatientContext(Order order, PatientHistoryChanges changes) {
        PatientContext result = null;
        Reference patient = order.getPatient().getObjectReference();
        List events = changes.getEvents(patient);
        Act event = events == null || events.isEmpty() ? changes.getEvent(order.getEvent()) : (Act)Collections.max(events, (o1, o2) -> DateRules.compareDateTime((Date)o1.getActivityStartTime(), (Date)o2.getActivityStartTime(), (boolean)true));
        if (event != null) {
            result = this.services.getFactory().createContext(order.getPatient(), this.customer, event, this.location, order.getClinician());
        }
        return result;
    }

    private PatientContext getPatientContext(Order order, Map<Reference, Act> events) {
        PatientContext result = null;
        Act event = events.get(order.getEvent());
        if (event == null) {
            event = (Act)this.getObject(order.getEvent());
        }
        if (event == null) {
            event = this.services.getRules().getEvent(order.getPatient(), order.getStartTime(), this.location);
        }
        if (event != null) {
            events.put(order.getEvent(), event);
        }
        if (event != null) {
            PatientContextFactory factory = this.services.getFactory();
            result = factory.createContext(order.getPatient(), this.customer, event, this.location, order.getClinician());
        }
        return result;
    }

    static String toString(IMObject object) {
        return object != null ? object.getName() + " (" + object.getId() + ")" : "null";
    }

    private boolean createOrder(Order order, List<Act> invoiceItems, PatientHistoryChanges changes, Set<Party> patients, Set<Act> updated) {
        boolean result = false;
        PatientContext context = this.getPatientContext(order, changes);
        if (context != null) {
            this.notifyPatientInformation(context, changes, patients);
            if (order.create(context, this.services, this.user, invoiceItems, updated)) {
                result = true;
            }
        } else {
            log.warn("Cannot create order due to missing visit: {}", (Object)order);
        }
        return result;
    }

    private void cancelOrder(Order order, PatientHistoryChanges changes, Set<Party> patients, Set<Act> updated) {
        PatientContext context;
        if (!order.getActId().isNew() && (context = this.getPatientContext(order, changes)) != null) {
            this.notifyPatientInformation(context, changes, patients);
            order.cancel(context, this.services, this.user, updated);
        }
    }

    private void notifyPatientInformation(PatientContext context, PatientHistoryChanges changes, Set<Party> patients) {
        Act visit = context.getVisit();
        if (!patients.contains(context.getPatient()) && (changes.isNew(visit) || visit.getActivityEndTime() != null && DateRules.compareTo((Date)visit.getActivityEndTime(), (Date)new Date()) < 0)) {
            this.services.getInformationService().updated(context);
            patients.add(context.getPatient());
        }
    }

    private Entity getPharmacy(Product product) {
        return this.pharmacies.getPharmacy(product);
    }

    private Entity getLaboratory(Entity investigationType) {
        return this.services.getLaboratoryServices().getLaboratory(investigationType, this.location);
    }

    private IMObject getObject(Reference reference) {
        return reference != null ? this.cache.get(reference) : null;
    }

    private boolean updateOrder(Order order, List<Act> invoiceItems, PatientHistoryChanges changes, Set<Party> patients, Set<Act> updated) {
        boolean result = false;
        PatientContext context = this.getPatientContext(order, changes);
        if (context != null) {
            this.notifyPatientInformation(context, changes, patients);
            result = order.update(context, this.services, this.user, invoiceItems, updated);
        } else {
            log.warn("Cannot update order due to missing visit: {}", (Object)order);
        }
        return result;
    }

    private static class HL7LaboratoryOrder
    extends Order {
        private final Act investigation;
        private final String test;
        private final Entity lab;

        public HL7LaboratoryOrder(Act act, String test, Party patient, User clinician, Entity device, Reference event) {
            super(act.getObjectReference(), act.getActivityStartTime(), patient, clinician, event);
            this.investigation = act;
            this.test = test;
            this.lab = device;
        }

        @Override
        public boolean create(PatientContext context, OrderServices services, User user, List<Act> invoiceItems, Set<Act> updated) {
            LaboratoryOrderService service = services.getLaboratoryService();
            boolean created = service.createOrder(context, this.getPlacerOrderNumber(), this.test, this.getStartTime(), this.lab);
            if (created) {
                this.investigation.setStatus2("SENT");
                updated.add(this.investigation);
                this.markOrdered(invoiceItems, updated);
            }
            return created;
        }

        @Override
        public void cancel(PatientContext context, OrderServices services, User user, Set<Act> updated) {
            LaboratoryOrderService service = services.getLaboratoryService();
            boolean sent = service.cancelOrder(context, this.getPlacerOrderNumber(), this.test, this.getStartTime(), this.lab);
            if (sent) {
                this.investigation.setStatus("CANCELLED");
                updated.add(this.investigation);
            }
        }

        @Override
        public void discontinue(PatientContext context, OrderServices services, User user) {
        }

        @Override
        public boolean update(PatientContext context, OrderServices services, User user, List<Act> invoiceItems, Set<Act> updated) {
            return false;
        }

        @Override
        public void verifyOrder(Order newOrder) {
            HL7LaboratoryOrder other = (HL7LaboratoryOrder)newOrder;
            this.verifySame("Patient", (IMObject)this.getPatient(), (IMObject)newOrder.getPatient());
            this.verifySame("Test", this.test, other.test);
            this.verifySame("Laboratory", (IMObject)this.lab, (IMObject)other.lab);
        }

        @Override
        public boolean needsUpdate(Order newOrder) {
            return false;
        }

        @Override
        public boolean isPlaced() {
            return !"PENDING".equals(this.investigation.getStatus2());
        }
    }

    private static class LaboratoryOrder
    extends Order {
        private final Act investigation;
        private final Entity lab;

        LaboratoryOrder(Act act, Party patient, User clinician, Entity laboratory, Reference event) {
            super(act.getObjectReference(), act.getActivityStartTime(), patient, clinician, event);
            this.investigation = act;
            this.lab = laboratory;
        }

        @Override
        public boolean create(PatientContext context, OrderServices services, User user, List<Act> invoiceItems, Set<Act> updated) {
            boolean created = false;
            if ("PENDING".equals(this.investigation.getStatus2())) {
                OrderDispatcher dispatcher = services.getOrderDispatcher();
                dispatcher.create(this.investigation);
                created = true;
            }
            return created;
        }

        @Override
        public void cancel(PatientContext context, OrderServices services, User user, Set<Act> updated) {
            OrderDispatcher dispatcher = services.getOrderDispatcher();
            dispatcher.cancel(this.investigation);
            this.investigation.setStatus("CANCELLED");
            updated.add(this.investigation);
        }

        @Override
        public void discontinue(PatientContext context, OrderServices services, User user) {
        }

        @Override
        public boolean update(PatientContext context, OrderServices services, User user, List<Act> invoiceItems, Set<Act> updated) {
            return false;
        }

        @Override
        public void verifyOrder(Order newOrder) {
            LaboratoryOrder other = (LaboratoryOrder)newOrder;
            this.verifySame("Patient", (IMObject)this.getPatient(), (IMObject)newOrder.getPatient());
            this.verifySame("Laboratory", (IMObject)this.lab, (IMObject)other.lab);
        }

        @Override
        public boolean needsUpdate(Order newOrder) {
            return false;
        }

        @Override
        public boolean isPlaced() {
            return !"PENDING".equals(this.investigation.getStatus2());
        }
    }

    private static class PharmacyOrder
    extends Order {
        private final Act act;
        private final BigDecimal quantity;
        private final Entity pharmacy;
        private final Product product;
        private final ArchetypeService service;
        private final boolean oneway;
        private static final String RECEIVED_QUANTITY = "receivedQuantity";
        private static final String RETURNED_QUANTITY = "returnedQuantity";

        PharmacyOrder(Act act, Product product, Party patient, BigDecimal quantity, User clinician, Entity pharmacy, Reference event, ArchetypeService service) {
            super(act.getObjectReference(), act.getActivityStartTime(), patient, clinician, event);
            this.act = act;
            this.product = product;
            this.quantity = quantity;
            this.pharmacy = pharmacy;
            this.service = service;
            this.oneway = service.getBean((IMObject)pharmacy).getBoolean("oneway");
        }

        public Entity getPharmacy() {
            return this.pharmacy;
        }

        public Product getProduct() {
            return this.product;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        @Override
        public boolean create(PatientContext context, OrderServices services, User user, List<Act> invoiceItems, Set<Act> updated) {
            PharmacyOrderService service = services.getPharmacyService();
            boolean created = service.createOrder(context, this.product, this.quantity, this.getPlacerOrderNumber(), this.getStartTime(), this.pharmacy);
            if (created) {
                this.markOrdered(invoiceItems, updated);
                this.updateInvoiceItems(invoiceItems, updated);
            }
            return created;
        }

        @Override
        public boolean update(PatientContext context, OrderServices services, User user, List<Act> invoiceItems, Set<Act> updated) {
            boolean update = false;
            PharmacyOrderService service = services.getPharmacyService();
            if (service.updateOrder(context, this.product, this.quantity, this.getPlacerOrderNumber(), this.getStartTime(), this.pharmacy)) {
                this.updateInvoiceItems(invoiceItems, updated);
                update = true;
            }
            return update;
        }

        @Override
        public void cancel(PatientContext context, OrderServices services, User user, Set<Act> updated) {
            PharmacyOrderService service = services.getPharmacyService();
            service.cancelOrder(context, this.product, this.quantity, this.getPlacerOrderNumber(), this.getStartTime(), this.pharmacy);
        }

        @Override
        public void discontinue(PatientContext context, OrderServices services, User user) {
            PharmacyOrderService service = services.getPharmacyService();
            service.discontinueOrder(context, this.product, this.quantity, this.getPlacerOrderNumber(), this.getStartTime(), this.pharmacy);
        }

        @Override
        public void verifyOrder(Order newOrder) {
            PharmacyOrder other = (PharmacyOrder)newOrder;
            this.verifySame("Patient", (IMObject)this.getPatient(), (IMObject)newOrder.getPatient());
            this.verifySame("Product", (IMObject)this.product, (IMObject)other.getProduct());
            this.verifySame("Pharmacy", (IMObject)this.pharmacy, (IMObject)other.getPharmacy());
        }

        @Override
        public boolean needsUpdate(Order newOrder) {
            PharmacyOrder other = (PharmacyOrder)newOrder;
            return this.quantity.compareTo(other.getQuantity()) != 0 || !Objects.equals(this.getClinician(), other.getClinician());
        }

        @Override
        public boolean isPlaced() {
            return "ORDERED".equals(this.act.getStatus());
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + super.toString() + ", product=" + OrderPlacer.toString((IMObject)this.product) + ", quantity=" + this.quantity + ", pharmacy=" + OrderPlacer.toString((IMObject)this.pharmacy) + ", oneway=" + this.oneway + "]";
        }

        private void updateInvoiceItems(List<Act> invoiceItems, Set<Act> updated) {
            if (this.oneway) {
                for (Act item : invoiceItems) {
                    IMObjectBean bean = this.service.getBean((IMObject)item);
                    BigDecimal quantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
                    if (!Objects.equals(quantity, bean.getBigDecimal(RECEIVED_QUANTITY, BigDecimal.ZERO))) {
                        bean.setValue(RECEIVED_QUANTITY, (Object)quantity);
                        updated.add(item);
                    }
                    if (bean.getValue(RETURNED_QUANTITY) == null) continue;
                    bean.setValue(RETURNED_QUANTITY, null);
                    updated.add(item);
                }
            }
        }
    }

    private static abstract class Order {
        private final Reference actId;
        private final Date startTime;
        private final Party patient;
        private final User clinician;
        private final Reference event;

        Order(Reference actId, Date startTime, Party patient, User clinician, Reference event) {
            this.actId = actId;
            this.startTime = startTime;
            this.patient = patient;
            this.clinician = clinician;
            this.event = event;
        }

        public Reference getActId() {
            return this.actId;
        }

        public long getPlacerOrderNumber() {
            return this.getActId().getId();
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Party getPatient() {
            return this.patient;
        }

        public User getClinician() {
            return this.clinician;
        }

        public Reference getEvent() {
            return this.event;
        }

        public abstract boolean create(PatientContext var1, OrderServices var2, User var3, List<Act> var4, Set<Act> var5);

        public abstract void cancel(PatientContext var1, OrderServices var2, User var3, Set<Act> var4);

        public abstract void discontinue(PatientContext var1, OrderServices var2, User var3);

        public abstract boolean update(PatientContext var1, OrderServices var2, User var3, List<Act> var4, Set<Act> var5);

        public abstract void verifyOrder(Order var1);

        public abstract boolean needsUpdate(Order var1);

        public abstract boolean isPlaced();

        public String toString() {
            return "act=" + this.actId.getArchetype() + ":" + this.actId.getId() + ", patient=" + OrderPlacer.toString((IMObject)this.patient) + ", startTime=" + new Timestamp(this.startTime.getTime()) + ", clinician=" + OrderPlacer.toString((IMObject)this.clinician) + ", event=" + this.event;
        }

        protected void verifySame(String displayName, IMObject expected, IMObject actual) {
            if (!Objects.equals(expected, actual)) {
                throw new IllegalStateException(displayName + " cannot be changed on order: previous=" + OrderPlacer.toString(expected) + ", current=" + OrderPlacer.toString(actual));
            }
        }

        protected void verifySame(String displayName, Object expected, Object actual) {
            if (!Objects.equals(expected, actual)) {
                throw new IllegalStateException(displayName + " cannot be changed on order: previous=" + expected + ", current=" + actual);
            }
        }

        void markOrdered(List<Act> invoiceItems, Set<Act> updated) {
            for (Act item : invoiceItems) {
                if ("ORDERED".equals(item.getStatus())) continue;
                item.setStatus("ORDERED");
                updated.add(item);
            }
        }
    }
}

