/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeRemovalStates;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.patient.investigation.PatientInvestigationActEditor;

public class InvoiceItemRemovalStates
extends ChargeRemovalStates {
    private final InvestigationManager manager;
    private final Map<PatientInvestigationActEditor, List<Entity>> testsByInvestigation = new LinkedHashMap<PatientInvestigationActEditor, List<Entity>>();
    private final Map<FinancialAct, List<PatientInvestigationActEditor>> editorsByInvoiceItem = new LinkedHashMap<FinancialAct, List<PatientInvestigationActEditor>>();
    private final Map<FinancialAct, List<Entity>> testsByInvoiceItem = new LinkedHashMap<FinancialAct, List<Entity>>();

    public InvoiceItemRemovalStates(InvestigationManager manager) {
        this.manager = manager;
    }

    public void determineAffectedInvestigations(CustomerChargeActItemEditor itemEditor) {
        FinancialAct item = itemEditor.getObject();
        ArrayList<PatientInvestigationActEditor> editors = new ArrayList<PatientInvestigationActEditor>();
        for (DocumentAct investigation : this.manager.getInvestigations(item)) {
            List tests;
            IMObjectBean bean;
            PatientInvestigationActEditor editor;
            if ("CANCELLED".equals(investigation.getStatus()) || (editor = this.manager.getEditor(investigation.getObjectReference())) == null) continue;
            editors.add(editor);
            Product product = itemEditor.getProduct();
            if (product == null || !(bean = ServiceHelper.getArchetypeService().getBean((IMObject)product)).hasNode("tests") || (tests = bean.getTargets("tests", Entity.class)).isEmpty()) continue;
            this.testsByInvoiceItem.put(item, tests);
            List<Entity> remaining = this.getRemainingTests(editor);
            remaining.removeAll(tests);
        }
        if (!editors.isEmpty()) {
            this.editorsByInvoiceItem.put(item, editors);
        }
    }

    public Map<FinancialAct, List<PatientInvestigationActEditor>> getAffectedEditorsByInvoiceItem() {
        return this.editorsByInvoiceItem;
    }

    public boolean hasNoMoreTests(PatientInvestigationActEditor editor) {
        List<Entity> tests = this.testsByInvestigation.get((Object)editor);
        return tests != null && tests.isEmpty();
    }

    @Override
    protected IMObjectTableModel<Act> createModel(String archetype, LayoutContext context) {
        return new InvoiceItemModel(archetype, context);
    }

    private List<Entity> getRemainingTests(PatientInvestigationActEditor editor) {
        return this.testsByInvestigation.computeIfAbsent(editor, e -> new ArrayList<Entity>(e.getTests()));
    }

    private class InvoiceItemModel
    extends ChargeRemovalStates.ChargeModel {
        private int testsIndex;

        public InvoiceItemModel(String archetype, LayoutContext context) {
            super(archetype, context);
        }

        @Override
        protected void addColumns(DefaultTableColumnModel model) {
            if (!InvoiceItemRemovalStates.this.testsByInvoiceItem.isEmpty()) {
                this.testsIndex = this.getNextModelIndex((TableColumnModel)model);
                model.addColumn(InvoiceItemModel.createTableColumn((int)this.testsIndex, (String)"customer.charge.delete.tests"));
            } else {
                this.testsIndex = -1;
            }
            super.addColumns(model);
        }

        @Override
        protected Object getValue(Act object, TableColumn column, int row) {
            Object result = null;
            if (column.getModelIndex() == this.testsIndex) {
                List tests = (List)InvoiceItemRemovalStates.this.testsByInvoiceItem.get((FinancialAct)object);
                StringBuilder builder = new StringBuilder();
                if (tests != null && !tests.isEmpty()) {
                    Label label = LabelFactory.create((boolean)true);
                    tests.sort(IMObjectSorter.getNameComparator((boolean)true));
                    for (Entity test : tests) {
                        if (builder.length() != 0) {
                            builder.append("\n");
                        }
                        builder.append(test.getName());
                    }
                    label.setText(builder.toString());
                    result = label;
                }
            } else {
                result = super.getValue(object, column, row);
            }
            return result;
        }
    }
}

