/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.customer.charge.InvestigationOrderDialog;
import org.openvpms.web.workspace.workflow.investigation.OrderConfirmationDialog;
import org.openvpms.web.workspace.workflow.investigation.OrderConfirmationManager;

class InvestigationSubmitter {
    private final InvestigationManager investigationManager;
    private final LayoutContext context;

    InvestigationSubmitter(InvestigationManager manager, LayoutContext context) {
        this.investigationManager = manager;
        this.context = context;
    }

    public void select(final Consumer<List<DocumentAct>> listener) {
        Listener delegate = new Listener(){

            @Override
            public void submit(List<DocumentAct> investigations) {
                listener.accept(investigations);
            }

            @Override
            public void skip() {
            }

            @Override
            public void cancel() {
            }
        };
        InvestigationOrderDialog dialog = this.createDialog(delegate, false);
        dialog.show();
    }

    public void select(EditorQueue queue, Listener listener) {
        InvestigationOrderDialog dialog = this.createDialog(listener, true);
        queue.queue((PopupDialog)dialog);
    }

    public void confirm(List<DocumentAct> investigations, EditorQueue queue) {
        ArrayList<DocumentAct> acts = new ArrayList<DocumentAct>();
        for (DocumentAct investigation : investigations) {
            if (investigation == null || !this.canConfirm((Act)investigation)) continue;
            acts.add(investigation);
        }
        if (!acts.isEmpty()) {
            OrderConfirmationManager manager = new OrderConfirmationManager();
            ArrayList<OrderConfirmationDialog> dialogs = new ArrayList<OrderConfirmationDialog>();
            for (final DocumentAct investigation : acts) {
                OrderConfirmationDialog dialog = manager.createConfirmationDialog((Act)investigation, this.context.getHelpContext());
                if (dialog == null) continue;
                dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                    public void onClose(WindowPaneEvent event) {
                        InvestigationSubmitter.this.investigationManager.reload(investigation);
                    }
                });
                dialogs.add(dialog);
            }
            int count = 1;
            for (OrderConfirmationDialog dialog : dialogs) {
                String title = Messages.format((String)"customer.charge.laboratory.order.title", (Object[])new Object[]{count, dialogs.size()});
                dialog.setTitle(title);
                queue.queue((PopupDialog)dialog);
                ++count;
            }
        }
    }

    public boolean canSubmit() {
        List<DocumentAct> investigations = this.investigationManager.getUnconfirmedLaboratoryInvestigations();
        if (!investigations.isEmpty()) {
            for (DocumentAct investigation : investigations) {
                this.investigationManager.reload(investigation);
            }
            investigations = this.investigationManager.getUnconfirmedLaboratoryInvestigations();
        }
        return !investigations.isEmpty();
    }

    protected InvestigationOrderDialog createDialog(final Listener listener, boolean skip) {
        final InvestigationOrderDialog dialog = new InvestigationOrderDialog(this.investigationManager, this.context, skip);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onAction(String action) {
                if (action.equals("button.submit")) {
                    listener.submit(dialog.getSelections());
                }
                super.onAction(action);
            }

            public void onSkip() {
                listener.skip();
            }

            public void onCancel() {
                listener.cancel();
            }
        });
        return dialog;
    }

    private boolean canConfirm(Act investigation) {
        String orderStatus = investigation.getStatus2();
        return !"CANCELLED".equals(investigation.getStatus()) && ("CONFIRM".equals(orderStatus) || "CONFIRM_DEFERRED".equals(orderStatus));
    }

    public static interface Listener {
        public void submit(List<DocumentAct> var1);

        public void skip();

        public void cancel();
    }
}

