/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.laboratory.internal.service.OrderValidationService;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.Saveable;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.AbstractRemovableCollectionPropertyEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.DelegatingModifiable;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.patient.investigation.PatientInvestigationActEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvestigationManagerImpl
extends DelegatingModifiable
implements InvestigationManager,
Saveable {
    private final IArchetypeService service;
    private final LaboratoryRules laboratoryRules;
    private final OrderValidationService orderValidationService;
    private final LayoutContext context;
    private final InvestigationsCollectionPropertyEditor collectionEditor;
    private final Map<Reference, DocumentAct> investigationsByRef = new HashMap<Reference, DocumentAct>();
    private final Map<FinancialAct, Set<DocumentAct>> investigationsByItem = new HashMap<FinancialAct, Set<DocumentAct>>();
    private Runnable reloadListener;
    private AlertListener alertListener;
    private static final Logger log = LoggerFactory.getLogger(InvestigationManagerImpl.class);
    private static final String TESTS = "tests";

    InvestigationManagerImpl(IArchetypeService service, LaboratoryRules laboratoryRules, OrderValidationService orderValidationService, LayoutContext context) {
        this.service = service;
        this.laboratoryRules = laboratoryRules;
        this.orderValidationService = orderValidationService;
        this.context = context;
        this.collectionEditor = new InvestigationsCollectionPropertyEditor();
        this.setModifiable((Modifiable)this.collectionEditor);
    }

    @Override
    public List<PatientInvestigationActEditor> updatePatient(CustomerChargeActItemEditor editor, Party patient) {
        Product product;
        List<PatientInvestigationActEditor> result = Collections.emptyList();
        this.removeInvoiceItem(editor);
        if (patient != null && (product = editor.getProduct()) != null) {
            result = this.generateInvestigations(editor, patient, product);
        }
        return result;
    }

    @Override
    public List<PatientInvestigationActEditor> updateProduct(CustomerChargeActItemEditor editor, Product product) {
        Party patient;
        List<PatientInvestigationActEditor> result = Collections.emptyList();
        this.removeInvoiceItem(editor);
        if (product != null && (patient = editor.getPatient()) != null) {
            result = this.generateInvestigations(editor, patient, product);
        }
        return result;
    }

    @Override
    public void updateClinician(FinancialAct item, User clinician) {
        for (DocumentAct act : this.getInvestigations(item, true)) {
            PatientInvestigationActEditor editor = this.getEditor(act);
            editor.setClinician(clinician);
        }
    }

    @Override
    public void updateTime(FinancialAct item) {
        for (DocumentAct act : this.getInvestigations(item, true)) {
            PatientInvestigationActEditor editor = this.getEditor(act);
            editor.setStartTime(item.getActivityStartTime());
        }
    }

    @Override
    public void addInvoiceItem(FinancialAct item) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        for (Reference reference : bean.getTargetRefs("investigations")) {
            DocumentAct investigation = this.investigationsByRef.get(reference);
            if (investigation == null && (investigation = (DocumentAct)this.service.get(reference, DocumentAct.class)) != null) {
                this.collectionEditor.add((IMObject)investigation);
                this.addEditor(investigation, item);
            }
            if (investigation == null) continue;
            this.addItemInvestigationItem(item, investigation);
        }
    }

    @Override
    public void removeInvoiceItem(FinancialAct item) {
        List<ActRelationship> relationships = this.removeItem(item);
        for (ActRelationship relationship : relationships) {
            item.removeActRelationship(relationship);
        }
    }

    @Override
    public void removeInvoiceItem(CustomerChargeActItemEditor editor) {
        FinancialAct item = editor.getObject();
        CollectionProperty investigations = editor.getCollectionProperty("investigations");
        for (ActRelationship relationship : this.removeItem(item)) {
            investigations.remove((Object)relationship);
        }
    }

    @Override
    public PatientInvestigationActEditor getEditor(Reference investigationRef) {
        DocumentAct act = this.investigationsByRef.get(investigationRef);
        return (PatientInvestigationActEditor)this.collectionEditor.getEditor((IMObject)act);
    }

    @Override
    public List<DocumentAct> getInvestigations() {
        return new ArrayList<DocumentAct>(this.investigationsByRef.values());
    }

    @Override
    public List<DocumentAct> getInvestigations(boolean ignorePending) {
        List<DocumentAct> result = this.getInvestigations();
        if (ignorePending) {
            result.removeIf(act -> "PENDING".equals(act.getStatus2()));
        }
        return result;
    }

    @Override
    public List<DocumentAct> getInvestigations(FinancialAct item) {
        return this.getInvestigations(item, false);
    }

    @Override
    public List<DocumentAct> getUnconfirmedLaboratoryInvestigations() {
        ArrayList<DocumentAct> result = new ArrayList<DocumentAct>();
        for (DocumentAct investigation : this.getInvestigations()) {
            if (!this.laboratoryRules.isUnsubmittedInvestigation((Act)investigation)) continue;
            result.add(investigation);
        }
        return result;
    }

    @Override
    public List<PatientInvestigationActEditor> getEditors() {
        ArrayList<PatientInvestigationActEditor> result = new ArrayList<PatientInvestigationActEditor>();
        for (DocumentAct act : this.getInvestigations()) {
            PatientInvestigationActEditor editor = this.getEditor(act.getObjectReference());
            if (editor == null) continue;
            result.add(editor);
        }
        return result;
    }

    @Override
    public boolean removeInvestigation(DocumentAct investigation) {
        return this.collectionEditor.remove((IMObject)investigation);
    }

    @Override
    public DocumentAct reload(DocumentAct investigation) {
        DocumentAct result;
        Reference ref = investigation.getObjectReference();
        DocumentAct reloaded = (DocumentAct)this.service.get(ref, DocumentAct.class);
        if (reloaded != null && reloaded.getVersion() != investigation.getVersion()) {
            result = reloaded;
            if (this.investigationsByRef.get(ref) != null) {
                this.collectionEditor.refresh(reloaded);
                for (Set<DocumentAct> set : this.investigationsByItem.values()) {
                    if (!set.contains(investigation)) continue;
                    set.remove(investigation);
                    set.add(reloaded);
                }
            }
            if (this.reloadListener != null) {
                try {
                    this.reloadListener.run();
                }
                catch (Throwable exception) {
                    log.error("Failed to callback reload listener: " + exception.getMessage(), exception);
                }
            }
        } else {
            result = investigation;
        }
        return result;
    }

    @Override
    public void setReloadListener(Runnable callback) {
        this.reloadListener = callback;
    }

    @Override
    public CollectionPropertyEditor getEditor() {
        return this.collectionEditor;
    }

    public void save() {
        this.collectionEditor.save();
    }

    public boolean isSaved() {
        return this.collectionEditor.isSaved();
    }

    @Override
    public void setAlertListener(AlertListener listener) {
        this.alertListener = listener;
    }

    protected void addEditor(DocumentAct investigation, FinancialAct item) {
        PatientInvestigationActEditor editor = this.createEditor(investigation, (Act)item);
        this.collectionEditor.setEditor((IMObject)investigation, (IMObjectEditor)editor);
    }

    private List<ActRelationship> removeItem(FinancialAct item) {
        ArrayList<ActRelationship> result = new ArrayList<ActRelationship>();
        IMObjectBean bean = this.service.getBean((IMObject)item);
        List<DocumentAct> investigations = this.getInvestigations(item);
        if (!investigations.isEmpty()) {
            Product product = (Product)this.getEntity(bean.getTargetRef("product"));
            List<Entity> tests = product != null ? this.getTests(product) : Collections.emptyList();
            for (DocumentAct investigation : investigations) {
                ActRelationship relationship = (ActRelationship)bean.getValue("investigations", ActRelationship.class, Predicates.targetEquals((IMObject)investigation));
                if (relationship == null) continue;
                result.add(relationship);
                PatientInvestigationActEditor investigationEditor = this.getEditor(investigation);
                if (investigationEditor == null) continue;
                if (investigationEditor.canEdit()) {
                    if (product != null) {
                        investigationEditor.removeProduct(product);
                        for (Entity test : tests) {
                            investigationEditor.removeTest(test);
                        }
                    }
                } else {
                    investigationEditor.setStatus("CANCELLED");
                }
                CollectionProperty invoiceItems = investigationEditor.getCollectionProperty("invoiceItems");
                invoiceItems.remove((Object)relationship);
                if (!invoiceItems.getValues().isEmpty()) continue;
                this.collectionEditor.remove((IMObject)investigation);
            }
        }
        this.investigationsByItem.remove(item);
        return result;
    }

    private boolean canRemove(DocumentAct investigation) {
        return "IN_PROGRESS".equals(investigation.getStatus()) && investigation.getDocument() == null;
    }

    private void addItemInvestigationItem(FinancialAct item, DocumentAct investigation) {
        Set investigations = this.investigationsByItem.computeIfAbsent(item, k -> new HashSet());
        investigations.add(investigation);
    }

    private PatientInvestigationActEditor getEditor(DocumentAct act) {
        return (PatientInvestigationActEditor)this.collectionEditor.getEditor((IMObject)act);
    }

    private void doAdd(DocumentAct investigation) {
        this.investigationsByRef.put(investigation.getObjectReference(), investigation);
    }

    private boolean doRemove(DocumentAct investigation) {
        boolean removed;
        boolean bl = removed = this.investigationsByRef.remove(investigation.getObjectReference()) != null;
        if (removed) {
            IMObjectBean bean = this.service.getBean((IMObject)investigation);
            for (ActRelationship relationship : bean.getValues("invoiceItems", ActRelationship.class)) {
                for (Map.Entry<FinancialAct, Set<DocumentAct>> entry : this.investigationsByItem.entrySet()) {
                    FinancialAct item = entry.getKey();
                    if (!item.getObjectReference().equals((Object)relationship.getSource())) continue;
                    item.removeActRelationship(relationship);
                    investigation.removeActRelationship(relationship);
                    entry.getValue().remove(investigation);
                }
            }
        }
        return removed;
    }

    private List<DocumentAct> getInvestigations(FinancialAct item, boolean unique) {
        List<DocumentAct> result;
        Set<DocumentAct> acts = this.investigationsByItem.get(item);
        if (acts == null) {
            result = Collections.emptyList();
        } else if (!unique) {
            result = new ArrayList<DocumentAct>(acts);
        } else {
            result = new ArrayList<DocumentAct>();
            for (DocumentAct act : acts) {
                IMObjectBean bean = this.service.getBean((IMObject)act);
                if (bean.getTargetRefs("invoiceItems").size() != 1) continue;
                result.add(act);
            }
        }
        return result;
    }

    private List<PatientInvestigationActEditor> generateInvestigations(CustomerChargeActItemEditor item, Party patient, Product product) {
        LinkedHashSet<PatientInvestigationActEditor> result = new LinkedHashSet<PatientInvestigationActEditor>();
        for (Entity test : this.getTests(product)) {
            PatientInvestigationActEditor editor = this.generateInvestigation(item, patient, product, test);
            if (editor == null) continue;
            result.add(editor);
        }
        return new ArrayList<PatientInvestigationActEditor>(result);
    }

    private PatientInvestigationActEditor generateInvestigation(CustomerChargeActItemEditor item, Party patient, Product product, Entity test) {
        PatientInvestigationActEditor investigationEditor = null;
        IMObjectBean bean = this.service.getBean((IMObject)test);
        Entity investigationType = this.getEntity(bean.getTargetRef("investigationType"));
        if (investigationType != null) {
            for (IMObjectEditor editor : this.collectionEditor.getEditors()) {
                PatientInvestigationActEditor candidate = (PatientInvestigationActEditor)editor;
                if (!candidate.canAddTest(patient, test)) continue;
                investigationEditor = candidate;
                break;
            }
            if (investigationEditor != null) {
                investigationEditor.addProduct(product);
                investigationEditor.addTest(test);
                item.addInvestigation(investigationEditor);
            } else {
                DocumentAct act = (DocumentAct)this.service.create("act.patientInvestigation", DocumentAct.class);
                investigationEditor = this.createEditor(act, (Act)item.getObject());
                investigationEditor.getComponent();
                investigationEditor.setInvestigationType(investigationType);
                investigationEditor.setPatient(patient);
                investigationEditor.addProduct(product);
                investigationEditor.addTest(test);
                investigationEditor.setClinician(item.getClinician());
                item.addInvestigation(investigationEditor);
                this.collectionEditor.add((IMObject)act);
                this.collectionEditor.setEditor((IMObject)act, (IMObjectEditor)investigationEditor);
            }
            this.addItemInvestigationItem(item.getObject(), investigationEditor.getObject());
        }
        return investigationEditor;
    }

    private List<Entity> getTests(Product product) {
        List<Entity> result;
        IMObjectBean bean = this.service.getBean((IMObject)product);
        if (bean.hasNode(TESTS)) {
            result = new ArrayList();
            for (Reference reference : bean.getTargetRefs(TESTS)) {
                Entity test = this.getEntity(reference);
                if (test == null) continue;
                result.add(test);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private Entity getEntity(Reference reference) {
        return (Entity)this.context.getCache().get(reference, true);
    }

    private PatientInvestigationActEditor createEditor(DocumentAct investigation, Act parent) {
        PatientInvestigationActEditor newEditor = new PatientInvestigationActEditor(investigation, parent, this.context);
        newEditor.setAlertListener(this.alertListener);
        return newEditor;
    }

    @Override
    public OrderValidationService.ValidationStatus validate(DocumentAct investigation) {
        return this.orderValidationService.validate(investigation);
    }

    private class InvestigationsCollection
    extends SimpleProperty
    implements CollectionProperty {
        InvestigationsCollection() {
            super("investigations", DocumentAct.class);
            this.setArchetypeRange(new String[]{"act.patientInvestigation"});
        }

        public void add(Object value) {
            InvestigationManagerImpl.this.doAdd((DocumentAct)value);
            this.refresh();
        }

        public boolean remove(Object value) {
            boolean removed = InvestigationManagerImpl.this.doRemove((DocumentAct)value);
            if (removed) {
                this.refresh();
            }
            return removed;
        }

        public List<?> getValues() {
            return InvestigationManagerImpl.this.getInvestigations();
        }

        public int size() {
            return InvestigationManagerImpl.this.investigationsByRef.size();
        }

        public int getMinCardinality() {
            return 0;
        }

        public int getMaxCardinality() {
            return -1;
        }

        public boolean isParentChild() {
            return false;
        }
    }

    private class InvestigationsCollectionPropertyEditor
    extends AbstractRemovableCollectionPropertyEditor {
        InvestigationsCollectionPropertyEditor() {
            super((CollectionProperty)new InvestigationsCollection());
        }

        public void refresh(DocumentAct investigation) {
            InvestigationManagerImpl.this.doAdd(investigation);
            PatientInvestigationActEditor existing = (PatientInvestigationActEditor)this.getEditor((IMObject)investigation);
            if (existing != null) {
                PatientInvestigationActEditor newEditor = InvestigationManagerImpl.this.createEditor(investigation, (Act)existing.getParent());
                this.setEditor((IMObject)investigation, (IMObjectEditor)newEditor);
                this.getEditor((IMObject)investigation);
            }
        }

        protected void queueRemove(IMObject object, IMObjectEditor editor) {
            if (InvestigationManagerImpl.this.canRemove((DocumentAct)object)) {
                super.queueRemove(object, editor);
            }
        }
    }
}

