/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.patient.mr.PatientMedicationActEditor;

public class DefaultEditorQueue
implements EditorQueue {
    private final Context context;
    private final LinkedList<State> queue = new LinkedList();
    private boolean started;
    private boolean executing;
    private State current;

    public DefaultEditorQueue(Context context) {
        this(true, context);
    }

    public DefaultEditorQueue(boolean started, Context context) {
        this.started = started;
        this.context = context;
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            if (!this.executing) {
                this.next();
            }
        }
    }

    @Override
    public boolean isQueued(IMObjectEditor editor) {
        if (this.current instanceof EditorState && ((EditorState)this.current).hasEditor(editor)) {
            return true;
        }
        for (State state : this.queue) {
            if (!(state instanceof EditorState) || !((EditorState)state).hasEditor(editor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void queue(IMObject owner, IMObjectEditor editor, boolean skip, boolean cancel, EditorQueue.Listener listener) {
        this.queue(new EditorState(owner, editor, listener, skip, cancel));
    }

    @Override
    public void queue(PopupDialog dialog) {
        this.queue(null, dialog, null);
    }

    @Override
    public void queue(IMObject owner, PopupDialog dialog) {
        this.queue(owner, dialog, null);
    }

    @Override
    public void queue(IMObject owner, PopupDialog dialog, Runnable callback) {
        this.queue(new DialogState(owner, dialog, callback));
    }

    @Override
    public void queue(Runnable runnable) {
        this.queue(new RunnableState(runnable));
    }

    @Override
    public void queue(Consumer<Runnable> consumer) {
        this.queue(new ConsumerState(consumer));
    }

    @Override
    public PopupDialog getCurrent() {
        return this.current != null ? this.current.getDialog() : null;
    }

    @Override
    public void cancel(IMObject owner) {
        boolean cancelled = false;
        if (this.current != null && this.current.isCancelledBy(owner)) {
            this.executing = false;
            this.current.cancel();
            this.current = null;
            cancelled = true;
        }
        if (!this.queue.isEmpty()) {
            cancelled |= this.queue.removeIf(state -> state.isCancelledBy(owner));
        }
        if (cancelled && !this.executing && this.queue.isEmpty()) {
            this.completed();
        }
    }

    @Override
    public boolean isComplete() {
        return !this.executing && this.queue.isEmpty();
    }

    protected void next() {
        this.executing = false;
        if (this.queue.isEmpty()) {
            this.completed();
            return;
        }
        State state = this.queue.removeFirst();
        state.show();
    }

    protected void edit(EditDialog dialog) {
        this.show((PopupDialog)dialog);
    }

    protected void show(PopupDialog dialog) {
        dialog.show();
    }

    protected void execute(Runnable runnable) {
        try {
            runnable.run();
            this.next();
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception, this::next);
        }
    }

    protected void skipped() {
        this.next();
    }

    protected void completed() {
        this.current = null;
        this.executing = false;
    }

    protected void cancelled() {
        while (!this.queue.isEmpty()) {
            State state = this.queue.removeFirst();
            if (!(state instanceof EditorState)) continue;
            ((EditorState)state).skip();
        }
        this.executing = false;
    }

    private void show(State state) {
        this.setExecuting(state);
        this.show(state.getDialog());
    }

    private void edit(EditorState state) {
        this.setExecuting(state);
        this.edit(state.getDialog());
    }

    private void setExecuting(State state) {
        this.executing = true;
        this.current = state;
    }

    private void queue(State state) {
        this.queue.addLast(state);
        if (!this.executing) {
            this.next();
        }
    }

    private String getTitle(IMObjectEditor editor) {
        PatientMedicationActEditor meditor;
        Party patient;
        String title = editor.getTitle();
        if (editor instanceof PatientMedicationActEditor && (patient = (meditor = (PatientMedicationActEditor)editor).getPatient()) != null) {
            PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
            String name = patient.getName();
            String weight = rules.getPatientWeight(patient);
            if (weight == null) {
                weight = Messages.get((String)"patient.noweight");
            }
            title = Messages.format((String)"patient.medication.dialog.title", (Object[])new Object[]{title, name, weight});
        }
        return title;
    }

    private static abstract class State {
        private final IMObject owner;
        private PopupDialog dialog;

        State(IMObject owner) {
            this.owner = owner;
        }

        abstract void show();

        PopupDialog getDialog() {
            return this.dialog;
        }

        void setDialog(PopupDialog dialog) {
            this.dialog = dialog;
        }

        boolean isCancelledBy(IMObject object) {
            return this.owner != null && Objects.equals(this.owner, object);
        }

        void cancel() {
            if (this.dialog != null && this.dialog.getParent() != null) {
                this.dialog.getParent().remove((Component)this.dialog);
                this.dialog = null;
            }
        }
    }

    private class ConsumerState
    extends State {
        private final Consumer<Runnable> consumer;
        private boolean next;

        ConsumerState(Consumer<Runnable> consumer) {
            super(null);
            this.consumer = consumer;
        }

        @Override
        public void show() {
            try {
                DefaultEditorQueue.this.executing = true;
                this.consumer.accept(() -> {
                    if (!this.next) {
                        this.next = true;
                        DefaultEditorQueue.this.next();
                    }
                });
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception, DefaultEditorQueue.this::next);
            }
        }
    }

    private class RunnableState
    extends State {
        private final Runnable runnable;

        RunnableState(Runnable runnable) {
            super(null);
            this.runnable = runnable;
        }

        @Override
        public void show() {
            DefaultEditorQueue.this.execute(this.runnable);
        }
    }

    private class DialogState
    extends State {
        private final Runnable callback;
        private final WindowPaneListener listener;

        DialogState(IMObject owner, PopupDialog dialog, Runnable callback) {
            super(owner);
            this.setDialog(dialog);
            this.callback = callback;
            this.listener = (WindowPaneListener & Serializable)e -> this.onClose();
        }

        @Override
        public void show() {
            this.getDialog().addWindowPaneListener(this.listener);
            DefaultEditorQueue.this.show(this);
        }

        private void onClose() {
            this.getDialog().removeWindowPaneListener(this.listener);
            DefaultEditorQueue.this.executing = false;
            if (this.callback != null) {
                this.callback.run();
            }
            DefaultEditorQueue.this.next();
        }
    }

    private class EditorState
    extends State {
        final IMObjectEditor editor;
        final EditorQueue.Listener listener;
        final boolean skip;
        final boolean cancel;

        EditorState(IMObject owner, IMObjectEditor editor, EditorQueue.Listener listener, boolean skip, boolean cancel) {
            super(owner);
            this.editor = editor;
            this.listener = listener;
            this.skip = skip;
            this.cancel = cancel;
        }

        @Override
        public void show() {
            EditActions actions = EditActions.ok().setSave(false).setShowCancel(this.cancel).setShowSkip(this.skip);
            EditDialogFactory factory = (EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class);
            EditDialog dialog = factory.supportsEditActions(this.editor) ? factory.create(this.editor, actions, DefaultEditorQueue.this.context) : new EditDialog(this.editor, actions, DefaultEditorQueue.this.context);
            dialog.setTitle(DefaultEditorQueue.this.getTitle(this.editor));
            dialog.setStyleName("ChildEditDialog");
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    this.doNext(false, false);
                }

                public void onCancel() {
                    this.doNext(false, true);
                }

                public void onSkip() {
                    this.doNext(true, false);
                }

                private void doNext(boolean skipped, boolean cancelled) {
                    DefaultEditorQueue.this.executing = false;
                    DefaultEditorQueue.this.current = null;
                    if (EditorState.this.listener != null) {
                        EditorState.this.listener.completed(skipped, cancelled);
                    }
                    if (skipped) {
                        DefaultEditorQueue.this.skipped();
                    } else if (cancelled) {
                        DefaultEditorQueue.this.cancelled();
                    } else {
                        DefaultEditorQueue.this.next();
                    }
                }
            });
            this.setDialog((PopupDialog)dialog);
            DefaultEditorQueue.this.edit(this);
        }

        public void skip() {
            this.listener.completed(true, false);
        }

        EditDialog getDialog() {
            return (EditDialog)super.getDialog();
        }

        boolean hasEditor(IMObjectEditor editor) {
            return this.editor.equals(editor);
        }

        @Override
        boolean isCancelledBy(IMObject object) {
            return super.isCancelledBy(object) || this.editor.getObject().equals(object);
        }
    }
}

