/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.openvpms.archetype.rules.finance.invoice.ChargeItemEventLinker;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditorFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.FinancialActEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeDocumentManager;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.ChargeLayoutStrategy;
import org.openvpms.web.workspace.customer.charge.ChargeSaveContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.customer.charge.InvestigationSubmitter;
import org.openvpms.web.workspace.customer.charge.OrderPlacer;
import org.openvpms.web.workspace.customer.charge.OrderServices;
import org.openvpms.web.workspace.patient.charge.TemplateChargeItems;

public abstract class CustomerChargeActEditor
extends FinancialActEditor {
    private final ReminderRules reminderRules;
    private final ChargeDocumentManager documentManager;
    private boolean addDefaultItem;
    private ActRelationshipCollectionEditor customerNotes;
    private ActRelationshipCollectionEditor documents;
    private OrderPlacer orderPlacer;
    private InvestigationSubmitter investigationSubmitter;

    public CustomerChargeActEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        this(act, parent, context, true);
    }

    public CustomerChargeActEditor(FinancialAct act, IMObject parent, LayoutContext context, boolean addDefaultItem) {
        super(act, parent, context);
        Party location = this.initLocation();
        Party customer = context.getContext().getCustomer();
        this.initParticipant("customer", (IMObject)customer);
        this.addDefaultItem = addDefaultItem;
        this.reminderRules = (ReminderRules)ServiceHelper.getBean(ReminderRules.class);
        this.initialise();
        if (act.isA("act.customerAccountChargesInvoice")) {
            ChargeItemRelationshipCollectionEditor items = this.getItems();
            items.setTemplateProductListener(this::templateProductExpanded);
            this.orderPlacer = this.createOrderPlacer(customer, context.getContext().getPractice(), location, context.getContext().getUser());
            List<Act> acts = this.getOrderActs(false);
            this.orderPlacer.initialise(acts);
            InvestigationManager manager = items.getEditContext().getInvestigations();
            this.investigationSubmitter = new InvestigationSubmitter(manager, context);
        }
        this.documentManager = new ChargeDocumentManager(this, context);
    }

    public void setAddDefaultItem(boolean addDefaultItem) {
        this.addDefaultItem = addDefaultItem;
    }

    public void setAddItemListener(Runnable listener) {
        this.getItems().setAddItemListener(listener);
    }

    public Party getCustomer() {
        return (Party)this.getParticipant("customer");
    }

    public Party getLocation() {
        return (Party)this.getParticipant("location");
    }

    public Entity getDepartment() {
        return this.getLayoutContext().getContext().getDepartment();
    }

    public Party getStockLocation() {
        return this.getLayoutContext().getContext().getStockLocation();
    }

    public ChargeItemRelationshipCollectionEditor getItems() {
        return (ChargeItemRelationshipCollectionEditor)super.getItems();
    }

    public EditorQueue getEditorQueue() {
        return this.getItems().getEditorQueue();
    }

    public ActRelationshipCollectionEditor getCustomerNotes() {
        CollectionProperty notes;
        if (this.customerNotes == null && (notes = (CollectionProperty)this.getProperty("customerNotes")) != null && !notes.isHidden()) {
            this.customerNotes = this.createCustomerNotesEditor((Act)this.getObject(), notes);
            this.addEditor((Editor)this.customerNotes);
        }
        return this.customerNotes;
    }

    public ActRelationshipCollectionEditor getDocuments() {
        CollectionProperty notes;
        if (this.documents == null && (notes = (CollectionProperty)this.getProperty("documents")) != null && !notes.isHidden()) {
            this.documents = this.createDocumentsEditor((Act)this.getObject(), notes);
            this.addEditor((Editor)this.documents);
        }
        return this.documents;
    }

    public CustomerChargeActItemEditor addItem() {
        IMObject object;
        ChargeItemRelationshipCollectionEditor items = this.getItems();
        CustomerChargeActItemEditor result = (CustomerChargeActItemEditor)items.add();
        if (result == null && (object = items.create()) != null) {
            result = (CustomerChargeActItemEditor)items.getEditor(object);
            items.addEdited((IMObjectEditor)result);
        }
        if (result != null && items.getCurrentEditor() == result) {
            this.getFocusGroup().setDefault(result.getFocusGroup().getDefaultFocus());
        }
        return result;
    }

    public void removeItem(Act item) {
        this.getItems().remove((IMObject)item);
        this.onItemsChanged();
    }

    public void setClinician(User clinician) {
        this.setParticipant("clinician", (Entity)clinician);
    }

    public void setOrdered(Act item) {
        if (this.orderPlacer != null) {
            this.orderPlacer.initialise(item);
        }
        if (this.getItems().hasEditor((IMObject)item)) {
            CustomerChargeActItemEditor editor = this.getItems().getEditor((IMObject)item);
            editor.ordered();
        }
    }

    public List<Act> getNonDispensedItems() {
        ArrayList<Act> result = new ArrayList<Act>();
        if (this.orderPlacer != null) {
            for (Act item : this.getItems().getCurrentActs()) {
                BigDecimal received;
                BigDecimal quantity;
                CustomerChargeActItemEditor editor = this.getItems().getEditor((IMObject)item);
                if (!editor.isOrdered() && !this.orderPlacer.isPharmacyProduct(editor.getProduct()) || MathRules.equals((BigDecimal)(quantity = editor.getQuantity()), (BigDecimal)(received = editor.getReceivedQuantity()))) continue;
                result.add(item);
            }
        }
        return result;
    }

    public void queue(PopupDialog dialog) {
        this.getItems().getEditorQueue().queue(null, dialog);
    }

    public ChargeDocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void postSave(final EditorQueue queue, boolean close, final MutableBoolean cancelled) {
        if (close) {
            if (this.investigationSubmitter != null && this.investigationSubmitter.canSubmit()) {
                InvestigationSubmitter.Listener listener = new InvestigationSubmitter.Listener(){

                    @Override
                    public void submit(List<DocumentAct> investigations) {
                        CustomerChargeActEditor.this.submitOrders(investigations);
                        CustomerChargeActEditor.this.investigationSubmitter.confirm(investigations, queue);
                        CustomerChargeActEditor.this.queueTasks(queue);
                    }

                    @Override
                    public void skip() {
                        CustomerChargeActEditor.this.submitOrdersExcludingInteractiveInvestigations();
                        CustomerChargeActEditor.this.queueTasks(queue);
                    }

                    @Override
                    public void cancel() {
                        cancelled.setTrue();
                    }
                };
                this.investigationSubmitter.select(queue, listener);
            } else {
                this.submitOrdersExcludingInteractiveInvestigations();
                this.queueTasks(queue);
            }
        } else {
            this.submitOrdersExcludingInteractiveInvestigations();
            this.queueTasks(queue);
        }
    }

    public void submitInvestigations() {
        if (this.investigationSubmitter != null) {
            if (this.isModified()) {
                throw new IllegalStateException("Can only submit investigations after changes have been saved");
            }
            if (this.investigationSubmitter.canSubmit()) {
                this.investigationSubmitter.select(investigations -> {
                    this.submitOrders((List<DocumentAct>)investigations);
                    EditorQueue editorQueue = this.getEditorQueue();
                    this.investigationSubmitter.confirm((List<DocumentAct>)investigations, editorQueue);
                });
            } else {
                InformationDialog.show((String)Messages.get((String)"customer.charge.investigation.submit.title"), (String)Messages.get((String)"customer.charge.investigation.submit.none"));
            }
        }
    }

    public void setAlertListener(AlertListener listener) {
        super.setAlertListener(listener);
        if (this.getObject().isA("act.customerAccountChargesInvoice")) {
            ChargeItemRelationshipCollectionEditor items = this.getItems();
            InvestigationManager manager = items.getEditContext().getInvestigations();
            manager.setAlertListener(listener);
        }
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateInvestigations(validator);
    }

    protected void queueTasks(EditorQueue queue) {
        if (this.documentManager != null) {
            this.documentManager.process(queue);
        }
    }

    protected Party initLocation() {
        Context context = this.getLayoutContext().getContext();
        Party location = this.getLocation();
        if (location == null) {
            location = context.getLocation();
            this.initParticipant("location", (IMObject)location);
        }
        context.setLocation(location);
        Party stockLocation = null;
        if (location != null) {
            LocationRules rules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
            stockLocation = rules.getDefaultStockLocation(location);
        }
        context.setStockLocation(stockLocation);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave() {
        ChargeSaveContext chargeContext = null;
        try {
            Set<Act> updated;
            ChargeItemRelationshipCollectionEditor items = this.getItems();
            List<Act> reminders = this.getNewReminders();
            List<Act> alerts = this.getNewAlerts();
            boolean invoice = this.getObject().isA("act.customerAccountChargesInvoice");
            IArchetypeService service = this.getService();
            PatientHistoryChanges changes = new PatientHistoryChanges(this.getLayoutContext().getContext().getLocation(), (ArchetypeService)service);
            if (invoice && !(updated = this.orderPlacer.cancelDeleted(this.getOrderActs(false), changes)).isEmpty()) {
                service.save(updated);
            }
            chargeContext = items.getSaveContext();
            chargeContext.setHistoryChanges(changes);
            boolean posted = this.isPosted();
            if (posted) {
                this.setEndTime(new Date(), true);
            }
            super.doSave();
            if (invoice) {
                this.linkToEvents(changes);
                if (posted) {
                    changes.complete(this.getEndTime());
                }
            }
            chargeContext.save();
            if (!reminders.isEmpty()) {
                this.reminderRules.markMatchingRemindersCompleted(reminders);
            }
            if (!alerts.isEmpty()) {
                this.reminderRules.markMatchingAlertsCompleted(alerts);
            }
            if (invoice) {
                this.submitOrders(this.getOrderActs(true), changes, true);
            }
        }
        finally {
            if (chargeContext != null) {
                chargeContext.setHistoryChanges(null);
            }
        }
    }

    protected void doDelete() {
        if (this.orderPlacer != null) {
            this.orderPlacer.cancel();
        }
        super.doDelete();
    }

    protected void linkToEvents(PatientHistoryChanges changes) {
        List chargeItems = this.getItems().getActs();
        ChargeItemEventLinker linker = new ChargeItemEventLinker((ArchetypeService)ServiceHelper.getArchetypeService());
        Map<FinancialAct, List<Act>> items = this.getItemsToLinkToEvents(chargeItems);
        linker.prepare(items, changes);
        this.addTemplateNotes(linker, changes);
    }

    protected Map<FinancialAct, List<Act>> getItemsToLinkToEvents(List<Act> chargeItems) {
        LinkedHashMap<FinancialAct, List<Act>> items = new LinkedHashMap<FinancialAct, List<Act>>();
        for (Act act : chargeItems) {
            FinancialAct financialAct = (FinancialAct)act;
            if (financialAct.getQuantity().compareTo(BigDecimal.ZERO) < 0) continue;
            ArrayList<Object> acts = new ArrayList<Object>();
            CustomerChargeActItemEditor editor = this.getItems().getEditor((IMObject)act);
            Act medication = editor.getMedication();
            if (medication != null) {
                acts.add(medication);
            }
            acts.addAll(editor.getInvestigations());
            acts.addAll(editor.getDocuments());
            items.put(financialAct, acts);
        }
        return items;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        ChargeLayoutStrategy strategy = new ChargeLayoutStrategy(this.getItems());
        this.initLayoutStrategy((IMObjectLayoutStrategy)strategy);
        return strategy;
    }

    protected void initLayoutStrategy(IMObjectLayoutStrategy strategy) {
        ActRelationshipCollectionEditor notes = this.getCustomerNotes();
        ActRelationshipCollectionEditor documents = this.getDocuments();
        if (notes != null) {
            strategy.addComponent(new ComponentState((PropertyEditor)notes));
        }
        if (documents != null) {
            strategy.addComponent(new ComponentState((PropertyEditor)documents));
        }
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.initItems();
    }

    protected void onItemsChanged() {
        super.onItemsChanged();
        this.calculateCosts();
    }

    protected ActRelationshipCollectionEditor createCustomerNotesEditor(Act act, CollectionProperty notes) {
        return (ActRelationshipCollectionEditor)IMObjectCollectionEditorFactory.create((CollectionProperty)notes, (IMObject)act, (LayoutContext)this.getLayoutContext());
    }

    protected ActRelationshipCollectionEditor createDocumentsEditor(Act act, CollectionProperty documents) {
        return (ActRelationshipCollectionEditor)IMObjectCollectionEditorFactory.create((CollectionProperty)documents, (IMObject)act, (LayoutContext)this.getLayoutContext());
    }

    protected OrderPlacer createOrderPlacer(Party customer, Party practice, Party location, User user) {
        OrderServices services = (OrderServices)ServiceHelper.getBean(OrderServices.class);
        return new OrderPlacer(customer, location, user, practice, this.getLayoutContext().getCache(), services, (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    protected boolean getAddDefaultIem() {
        return this.addDefaultItem;
    }

    protected void addTemplateNotes(ChargeItemEventLinker linker, PatientHistoryChanges changes) {
        List<TemplateChargeItems> templates = this.getItems().getTemplates();
        if (!templates.isEmpty()) {
            List items = this.getItems().getActs();
            ArrayList<Act> notes = new ArrayList<Act>();
            MedicalRecordRules rules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
            for (TemplateChargeItems template : templates) {
                IMObjectBean bean;
                Party patient;
                String visitNote;
                Act item = template.findFirst(items);
                if (item == null || StringUtils.isEmpty((CharSequence)(visitNote = template.getVisitNote())) || (patient = (Party)this.getObject((bean = this.getBean((IMObject)item)).getTargetRef("patient"))) == null) continue;
                Date itemStartTime = bean.getDate("startTime");
                Date startTime = this.getStartTime();
                if (DateRules.getDate((Date)itemStartTime).compareTo(DateRules.getDate((Date)startTime)) != 0) {
                    startTime = itemStartTime;
                }
                User clinician = (User)this.getObject(bean.getTargetRef("clinician"));
                Act note = rules.createNote(startTime, patient, visitNote, clinician);
                notes.add(note);
            }
            if (!notes.isEmpty()) {
                ServiceHelper.getArchetypeService().save(notes);
                linker.prepareNotes(notes, changes);
            }
            this.getItems().clearTemplates();
        }
    }

    private boolean validateInvestigations(Validator validator) {
        boolean valid = true;
        if (this.isPosted() && this.investigationSubmitter != null && this.investigationSubmitter.canSubmit()) {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"customer.charge.investigation.unsubmitted")));
            valid = false;
        }
        return valid;
    }

    private boolean isPosted() {
        return "POSTED".equals(this.getStatus());
    }

    private void submitOrdersExcludingInteractiveInvestigations() {
        InvestigationManager manager = this.getInvestigations();
        List<DocumentAct> unconfirmed = manager.getUnconfirmedLaboratoryInvestigations();
        List<DocumentAct> investigations = manager.getInvestigations();
        investigations.removeAll(unconfirmed);
        this.submitOrders(investigations);
    }

    private InvestigationManager getInvestigations() {
        return this.getItems().getEditContext().getInvestigations();
    }

    private void submitOrders(List<DocumentAct> investigations) {
        if (this.getObject().isA("act.customerAccountChargesInvoice")) {
            if (this.isModified()) {
                throw new IllegalStateException("Can only submit orders after changes have been saved");
            }
            PatientHistoryChanges changes = new PatientHistoryChanges(this.getLayoutContext().getContext().getLocation(), (ArchetypeService)ServiceHelper.getArchetypeService());
            this.submitOrders(this.getOrderActs(investigations), changes, false);
        }
    }

    private void submitOrders(List<Act> orderActs, PatientHistoryChanges changes, boolean discontinue) {
        ArrayList<DocumentAct> excluded = new ArrayList<DocumentAct>(this.getInvestigations().getInvestigations());
        excluded.removeAll(orderActs);
        Set<Act> updated = this.orderPlacer.order(orderActs, excluded, changes);
        if (discontinue && this.isPosted() && this.orderPlacer.discontinueOnFinalisation()) {
            updated.addAll(this.orderPlacer.discontinue(orderActs));
        }
        if (!updated.isEmpty()) {
            ServiceHelper.getArchetypeService((boolean)false).save(updated);
            for (Act item : updated) {
                if (item.isA("act.customerAccountInvoiceItem")) {
                    CustomerChargeActItemEditor editor = this.getItems().getEditor((IMObject)item);
                    editor.ordered();
                    continue;
                }
                if (!item.isA("act.patientInvestigation")) continue;
                this.getInvestigations().reload((DocumentAct)item);
            }
        }
    }

    private List<Act> getOrderActs(boolean ignorePendingLabOrders) {
        InvestigationManager manager = this.getItems().getEditContext().getInvestigations();
        List<DocumentAct> investigations = manager.getInvestigations(ignorePendingLabOrders);
        return this.getOrderActs(investigations);
    }

    private List<Act> getOrderActs(List<DocumentAct> investigations) {
        ChargeItemRelationshipCollectionEditor items = this.getItems();
        ArrayList<Act> acts = new ArrayList<Act>(items.getActs());
        acts.addAll(investigations);
        return acts;
    }

    private void initItems() {
        ChargeItemRelationshipCollectionEditor items;
        CollectionProperty property;
        if (this.addDefaultItem && (property = (items = this.getItems()).getCollection()).getValues().isEmpty()) {
            this.addItem();
        }
    }

    private void calculateCosts() {
        Property fixedCost = this.getProperty("fixedCost");
        BigDecimal fixed = ActHelper.sum((Act)this.getObject(), (Collection)this.getItems().getCurrentActs(), (String)"fixedCost");
        fixedCost.setValue((Object)fixed);
        Property unitCost = this.getProperty("unitCost");
        BigDecimal cost = BigDecimal.ZERO;
        for (Act act : this.getItems().getCurrentActs()) {
            cost = cost.add(this.calcTotalUnitCost(act));
        }
        unitCost.setValue((Object)cost);
    }

    private BigDecimal calcTotalUnitCost(Act act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        BigDecimal unitCost = bean.getBigDecimal("unitCost", BigDecimal.ZERO);
        BigDecimal quantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
        return unitCost.multiply(quantity);
    }

    private List<Act> getNewReminders() {
        ChargeItemRelationshipCollectionEditor items = this.getItems();
        ArrayList<Act> reminders = new ArrayList<Act>();
        for (IMObjectEditor editor : items.getEditors()) {
            if (!(editor instanceof CustomerChargeActItemEditor)) continue;
            CustomerChargeActItemEditor charge = (CustomerChargeActItemEditor)editor;
            for (Act reminder : charge.getReminders()) {
                if (!reminder.isNew()) continue;
                reminders.add(reminder);
            }
        }
        return reminders;
    }

    private List<Act> getNewAlerts() {
        return this.getItems().getEditContext().getAlerts().getNewAlerts();
    }

    private void templateProductExpanded(Product product) {
        IMObjectBean bean;
        String invoiceNote;
        Property property = this.getProperty("notes");
        if (property != null && !StringUtils.isEmpty((CharSequence)(invoiceNote = (bean = this.getBean((IMObject)product)).getString("invoiceNote")))) {
            String value = invoiceNote;
            if (property.getValue() != null) {
                value = property.getValue().toString();
                value = !StringUtils.isEmpty((CharSequence)value) ? value + "\n" + invoiceNote : invoiceNote;
            }
            property.setValue((Object)value);
        }
    }
}

