/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DefaultListMarkModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.im.table.ListMarkModel;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.customer.StockOnHand;

public class ChargeItemTableModel<T extends IMObject>
extends DescriptorTableModel<T> {
    private final StockOnHand stock;
    private boolean showTemplate;
    private boolean showProductType;
    private boolean showBatch;
    private boolean showDepartment;
    private int productIndex;
    private int templateIndex;
    private int productTypeIndex;
    private int beforeBatchIndex;
    private int clinicianIndex;
    private int onHandIndex = -1;
    private TableColumn template;
    private TableColumn productType;
    private TableColumn batch;
    private TableColumn department;
    private static final String ITEM_ID = "id";
    private static final String START_TIME = "startTime";
    private static final String PRODUCT = "product";
    private static final String BATCH = "batch";
    private static final String DEPARTMENT = "department";
    private static final String QUANTITY = "quantity";
    private static final String CLINICIAN = "clinician";
    private static final String TEMPLATE = "template";

    public ChargeItemTableModel(String[] shortNames, LayoutContext context) {
        this(shortNames, null, context);
    }

    public ChargeItemTableModel(String[] shortNames, StockOnHand stock, LayoutContext context) {
        super(context);
        this.stock = stock;
        Preferences preferences = context.getPreferences();
        this.showTemplate = preferences.getBoolean("entity.preferenceGroupCharge", "showTemplate", false);
        this.showProductType = preferences.getBoolean("entity.preferenceGroupCharge", "showProductType", false);
        this.showBatch = preferences.getBoolean("entity.preferenceGroupCharge", "showBatch", false);
        this.showDepartment = preferences.getBoolean("entity.preferenceGroupCharge", "showDepartment", false);
        TableColumnModel model = this.createColumnModel(shortNames, context);
        if (context.isEdit()) {
            this.addMarkColumn(model);
            this.setRowMarkModel((ListMarkModel)new DefaultListMarkModel());
        }
        this.setTableColumnModel(model);
        DescriptorTableColumn startTime = this.getColumn(START_TIME);
        if (startTime != null) {
            this.setDefaultSortColumn(startTime.getModelIndex());
            this.setDefaultSortAscending(false);
        } else {
            this.setDefaultSortColumn(this.getColumnModel().getColumn(0).getModelIndex());
        }
    }

    public void setShowProductType(boolean show) {
        if (show != this.showProductType) {
            this.doShowProductType(show, this.getColumnModel());
        }
    }

    public void setShowTemplate(boolean show) {
        if (show != this.showTemplate) {
            this.doShowTemplate(show, this.getColumnModel());
        }
    }

    public void setShowBatch(boolean show) {
        if (show != this.showBatch) {
            this.doShowBatch(show, this.getColumnModel());
        }
    }

    public boolean hasBatch() {
        return this.batch != null;
    }

    public void setShowDepartment(boolean show) {
        if (show != this.showDepartment) {
            this.doShowDepartment(show, this.getColumnModel());
        }
    }

    public DefaultTableColumnModel getColumnModel() {
        return (DefaultTableColumnModel)super.getColumnModel();
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        if (column == this.productTypeIndex) {
            return new SortConstraint[]{this.getProductTypeSortConstraint(ascending), new NodeSortConstraint(START_TIME, false), new NodeSortConstraint(ITEM_ID, true)};
        }
        if (column == this.templateIndex) {
            return new SortConstraint[]{new NodeSortConstraint(TEMPLATE, ascending), this.getProductTypeSortConstraint(ascending), new NodeSortConstraint(START_TIME, false), new NodeSortConstraint(ITEM_ID, true)};
        }
        return super.getSortConstraints(column, ascending);
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return super.getArchetypeNodes().exclude(new String[]{DEPARTMENT});
    }

    protected Object getValue(T object, TableColumn column, int row) {
        int index = column.getModelIndex();
        if (index == this.productTypeIndex) {
            return this.getProductType((IMObject)object);
        }
        if (index == this.onHandIndex) {
            return this.getOnHand((IMObject)object);
        }
        return super.getValue(object, column, row);
    }

    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        int offset;
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(archetypes, context);
        this.productIndex = this.getColumn((TableColumnModel)model, PRODUCT).getModelIndex();
        DescriptorTableColumn clinician = this.getColumn((TableColumnModel)model, CLINICIAN);
        this.clinicianIndex = clinician != null ? clinician.getModelIndex() : -1;
        this.batch = this.getColumn((TableColumnModel)model, BATCH);
        this.beforeBatchIndex = this.batch != null ? ((offset = this.getColumnOffset((TableColumnModel)model, this.batch.getModelIndex())) > 0 ? model.getColumn(offset - 1).getModelIndex() : 0) : -1;
        if (this.stock != null) {
            this.onHandIndex = this.getNextModelIndex((TableColumnModel)model);
            TableColumn onHand = new TableColumn(this.onHandIndex);
            onHand.setHeaderValue((Object)Messages.get((String)"product.stock.onhand"));
            DescriptorTableColumn quantity = this.getColumn((TableColumnModel)model, QUANTITY);
            this.addColumnAfter(onHand, quantity.getModelIndex(), (TableColumnModel)model);
        }
        this.templateIndex = this.getNextModelIndex((TableColumnModel)model);
        this.productTypeIndex = this.templateIndex + 1;
        this.productType = new TableColumn(this.productTypeIndex);
        this.productType.setHeaderValue((Object)this.getDisplayName("entity.productType"));
        this.template = new DescriptorTableColumn(this.templateIndex, TEMPLATE, archetypes);
        int departmentIndex = this.productTypeIndex + 1;
        this.department = new DescriptorTableColumn(departmentIndex, DEPARTMENT, archetypes);
        if (this.showTemplate) {
            this.doShowTemplate(true, model);
        }
        if (this.showProductType) {
            this.doShowProductType(true, model);
        }
        if (!this.showBatch) {
            this.doShowBatch(false, model);
        }
        if (this.showDepartment) {
            this.doShowDepartment(true, model);
        }
        return model;
    }

    private Component getProductType(IMObject object) {
        Component result = null;
        Reference type = this.getProductTypeRef(object);
        if (type != null) {
            result = new IMObjectReferenceViewer(type, null, this.getLayoutContext().getContext()).getComponent();
        }
        return result;
    }

    private Reference getProductTypeRef(IMObject object) {
        Reference result = null;
        IMObjectBean bean = this.getBean(object);
        LayoutContext context = this.getLayoutContext();
        IMObjectCache cache = context.getCache();
        Product product = (Product)cache.get(bean.getTargetRef(PRODUCT));
        if (product != null) {
            IMObjectBean productBean = this.getBean((IMObject)product);
            result = productBean.getTargetRef("type");
        }
        return result;
    }

    private Component getOnHand(IMObject object) {
        Label result = null;
        FinancialAct act = (FinancialAct)object;
        BigDecimal value = this.stock.getAvailableStock(act);
        if (value != null) {
            Label label = TableHelper.rightAlign((String)NumberFormatter.format((Number)value));
            if (value.compareTo(BigDecimal.ZERO) <= 0) {
                TableHelper.mergeStyle((Component)label, (String)"OutOfStock.Table");
            }
            result = label;
        }
        return result;
    }

    private void doShowTemplate(boolean show, DefaultTableColumnModel model) {
        int after = this.clinicianIndex != -1 ? this.clinicianIndex : this.productIndex;
        this.showTemplate = this.show(this.template, show, after, model);
    }

    private void doShowProductType(boolean show, DefaultTableColumnModel model) {
        int after = this.showTemplate ? this.templateIndex : (this.clinicianIndex != -1 ? this.clinicianIndex : this.productIndex);
        this.showProductType = this.show(this.productType, show, after, model);
    }

    private void doShowBatch(boolean show, DefaultTableColumnModel model) {
        if (this.batch != null) {
            this.showBatch = this.show(this.batch, show, this.beforeBatchIndex, model);
        }
    }

    private void doShowDepartment(boolean show, DefaultTableColumnModel model) {
        int after = this.showProductType ? this.productTypeIndex : (this.showTemplate ? this.templateIndex : this.clinicianIndex);
        this.showDepartment = this.show(this.department, show, after, model);
    }

    private boolean show(TableColumn column, boolean show, int after, DefaultTableColumnModel model) {
        if (show) {
            this.addColumnAfter(column, after, (TableColumnModel)model);
        } else {
            model.removeColumn(column);
        }
        this.fireTableStructureChanged();
        return show;
    }

    private SortConstraint getProductTypeSortConstraint(boolean ascending) {
        return new VirtualNodeSortConstraint("productType", ascending, input -> {
            Reference type;
            IMObject item;
            LayoutContext context = this.getLayoutContext();
            String result = null;
            if (input instanceof Relationship) {
                Relationship relationship = (Relationship)input;
                item = context.getCache().get(relationship.getTarget());
            } else {
                item = (IMObject)input;
            }
            if (item != null && (type = this.getProductTypeRef(item)) != null) {
                result = context.getNames().getName(type);
            }
            return result;
        });
    }
}

