/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.edit.Saveable;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditorFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeSaveContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.patient.mr.PatientDocumentActEditor;

class ChargeItemDocumentManager
extends AbstractPropertyEditor
implements Saveable {
    private final CustomerChargeActItemEditor editor;
    private final ActRelationshipCollectionEditor documents;
    private final IArchetypeService service;
    private static final Log log = LogFactory.getLog(ChargeItemDocumentManager.class);

    public ChargeItemDocumentManager(CustomerChargeActItemEditor editor, CollectionProperty property, ChargeSaveContext saveContext, LayoutContext context) {
        super((Property)property);
        this.editor = editor;
        this.documents = (ActRelationshipCollectionEditor)IMObjectCollectionEditorFactory.create((CollectionProperty)property, (IMObject)editor.getObject(), (LayoutContext)new DefaultLayoutContext(context));
        this.documents.setExcludeDefaultValueObject(false);
        this.documents.getEditor().setRemoveHandler((CollectionPropertyEditor.RemoveHandler)saveContext);
        this.documents.getComponent();
        for (Act act : this.documents.getCurrentActs()) {
            this.documents.getEditor((IMObject)act);
        }
        this.service = ServiceHelper.getArchetypeService();
    }

    public boolean isModified() {
        return this.documents.isModified();
    }

    public void clearModified() {
        this.documents.clearModified();
    }

    public Component getComponent() {
        return this.documents.getComponent();
    }

    public FocusGroup getFocusGroup() {
        return this.documents.getFocusGroup();
    }

    public void update() {
        Product product = this.editor.getProduct();
        Party patient = this.editor.getPatient();
        if (product == null || patient == null) {
            this.removeAll();
        } else {
            User clinician = this.editor.getClinician();
            HashSet<Reference> templateRefs = new HashSet<Reference>();
            for (Act document : this.documents.getCurrentActs()) {
                IMObjectBean bean = this.service.getBean((IMObject)document);
                if (this.productChanged(bean, product) || this.patientChanged(bean, patient)) {
                    this.documents.remove((IMObject)document);
                    continue;
                }
                Reference templateRef = bean.getTargetRef("documentTemplate");
                if (templateRef != null) {
                    templateRefs.add(templateRef);
                }
                if (!this.clinicianChanged(bean, clinician)) continue;
                if (bean.isA(new String[]{"act.patientDocumentLetter"})) {
                    this.promptForUpdate(bean, patient, product, clinician);
                    continue;
                }
                this.setClinician(document, clinician);
            }
            IMObjectBean productBean = this.service.getBean((IMObject)product);
            if (productBean.hasNode("documents")) {
                List productTemplateRefs = productBean.getTargetRefs("documents");
                productTemplateRefs.removeAll(templateRefs);
                if (!productTemplateRefs.isEmpty()) {
                    for (Reference reference : productTemplateRefs) {
                        Entity template = (Entity)this.service.get(reference, true);
                        if (template == null) continue;
                        this.addDocument(patient, productBean, clinician, new DocumentTemplate(template, (ArchetypeService)this.service));
                    }
                }
            }
        }
    }

    public void removeAll() {
        for (Act act : this.documents.getCurrentActs()) {
            this.documents.remove((IMObject)act);
        }
    }

    public void save() {
        this.documents.save();
    }

    public boolean isSaved() {
        return this.documents.isSaved();
    }

    public List<Act> getDocuments() {
        return this.documents.getActs();
    }

    private void promptForUpdate(IMObjectBean document, final Party patient, final Product product, final User clinician) {
        final DocumentAct act = (DocumentAct)document.getObject(DocumentAct.class);
        final Entity template = (Entity)document.getTarget("documentTemplate", Entity.class, Policies.active());
        if (template != null) {
            String title = Messages.format((String)"customer.charge.document.refresh.title", (Object[])new Object[]{document.getDisplayName()});
            String message = Messages.format((String)"customer.charge.document.refresh.message", (Object[])new Object[]{template.getName()});
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, ConfirmationDialog.YES_NO);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    ChargeItemDocumentManager.this.documents.remove((IMObject)act);
                    ChargeItemDocumentManager.this.addDocument(patient, ChargeItemDocumentManager.this.service.getBean((IMObject)product), clinician, new DocumentTemplate(template, (ArchetypeService)ChargeItemDocumentManager.this.service));
                }

                public void onNo() {
                    ChargeItemDocumentManager.this.setClinician((Act)act, clinician);
                }
            });
            this.editor.getEditorQueue().queue((IMObject)this.editor.getObject(), (PopupDialog)dialog);
        } else {
            this.setClinician((Act)act, clinician);
        }
    }

    private void setClinician(Act document, User clinician) {
        IMObjectEditor editor = this.documents.getEditor((IMObject)document);
        if (editor instanceof PatientDocumentActEditor) {
            ((PatientDocumentActEditor)editor).setClinician(clinician);
        } else {
            log.error((Object)("Cannot update clinician on " + editor.getClass().getName()));
        }
    }

    private void addDocument(Party patient, IMObjectBean product, User clinician, DocumentTemplate template) {
        String archetype = template.getType();
        if (TypeHelper.isA((String)archetype, (String[])new String[]{"act.patientDocument*"})) {
            DocumentAct documentAct = (DocumentAct)this.service.create(archetype, DocumentAct.class);
            this.addDocument(documentAct, patient, product, clinician, template);
        }
    }

    private void addDocument(DocumentAct act, Party patient, IMObjectBean product, User clinician, DocumentTemplate template) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        act.setActivityStartTime(this.editor.getStartTime());
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("clinician", (IMObject)clinician);
        if (bean.hasNode("documentTemplate")) {
            bean.setTarget("documentTemplate", (IMObject)template.getEntity());
        }
        if (bean.hasNode("product")) {
            bean.setTarget("product", product.getObject());
        }
        this.documents.add((IMObject)act);
    }

    private boolean productChanged(IMObjectBean bean, Product product) {
        return bean.hasNode("product") && !Objects.equals(bean.getTargetRef("product"), product.getObjectReference());
    }

    private boolean patientChanged(IMObjectBean docBean, Party patient) {
        return !Objects.equals(docBean.getTargetRef("patient"), patient.getObjectReference());
    }

    private boolean clinicianChanged(IMObjectBean docBean, User clinician) {
        Reference reference = clinician != null ? clinician.getObjectReference() : null;
        return !Objects.equals(docBean.getTargetRef("clinician"), reference);
    }
}

