/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account.payment;

import java.util.Date;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.table.TableColumn;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.dialog.OptionDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.account.payment.PaymentChanges;

class AdminPaymentActRelationshipCollectionEditor
extends ActRelationshipCollectionEditor {
    private final PaymentChanges audit = new PaymentChanges((IArchetypeService)ServiceHelper.getArchetypeService());

    public AdminPaymentActRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        super(property, act, context);
    }

    public boolean isCardinalityReadOnly() {
        return true;
    }

    public String getAuditMessage() {
        User user = this.getContext().getContext().getUser();
        String name = user != null ? user.getUsername() : "unknown";
        return this.audit.getAuditMessage(name, new Date());
    }

    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        IMObjectEditor editor = super.createEditor(object, context);
        if (editor instanceof PaymentItemEditor) {
            ((PaymentItemEditor)editor).setReadOnlyAmount(true);
        }
        return editor;
    }

    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        context = new DefaultLayoutContext(context);
        context.setComponentFactory((IMObjectComponentFactory)new TableComponentFactory(context));
        String[] archetypes = this.getCollectionPropertyEditor().getArchetypeRange();
        return new ItemTableModel(archetypes, context);
    }

    protected void change(FinancialAct act, String archetype) {
        if (!this.canChange(act)) {
            throw new IllegalStateException("Cannot change " + act.getId());
        }
        FinancialAct newAct = (FinancialAct)this.create(archetype);
        if (newAct != null) {
            newAct.setTotal(act.getTotal());
            this.remove((IMObject)act);
            this.add((IMObject)newAct);
            this.audit.addChange(act, newAct);
            this.refresh();
            this.setSelected((IMObject)newAct);
            this.onSelected();
        }
    }

    private void onChange(final FinancialAct act) {
        Object[] archetypeRange = this.getCollectionPropertyEditor().getArchetypeRange();
        final String[] archetypes = (String[])ArrayUtils.removeElement((Object[])archetypeRange, (Object)act.getArchetype());
        String[] displayNames = new String[archetypes.length];
        for (int i = 0; i < archetypes.length; ++i) {
            displayNames[i] = DescriptorHelper.getDisplayName((String)archetypes[i], (ArchetypeService)ServiceHelper.getArchetypeService());
        }
        final OptionDialog dialog = new OptionDialog(Messages.get((String)"customer.account.payment.change.title"), Messages.get((String)"customer.account.payment.change.message"), displayNames, OptionDialog.CANCEL);
        dialog.setCloseOnSelection(true);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                int selected = dialog.getSelected();
                if (selected >= 0 && selected < archetypes.length) {
                    AdminPaymentActRelationshipCollectionEditor.this.change(act, archetypes[selected]);
                }
            }
        });
        dialog.show();
    }

    private boolean canChange(FinancialAct act) {
        IMObjectBean bean;
        boolean result = true;
        if (act.isA(new String[]{"act.customerAccountPaymentEFT", "act.customerAccountPaymentPP"}) && !(bean = this.getBean((IMObject)act)).getValues("transactions").isEmpty()) {
            result = false;
        }
        return result;
    }

    private class ItemTableModel
    extends DescriptorTableModel<FinancialAct> {
        public ItemTableModel(String[] shortNames, LayoutContext context) {
            super(shortNames, context);
        }

        protected Object getValue(final FinancialAct object, TableColumn column, int row) {
            Object result;
            if (column.getModelIndex() == 2) {
                Label label = LabelFactory.text((String)DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)this.getService()));
                Button change = ButtonFactory.create((String)"button.change");
                if (AdminPaymentActRelationshipCollectionEditor.this.canChange(object)) {
                    change.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                        public void onAction(ActionEvent event) {
                            AdminPaymentActRelationshipCollectionEditor.this.onChange(object);
                        }
                    });
                } else {
                    change.setEnabled(false);
                }
                Row wrapper = RowFactory.create((Component[])new Component[]{change});
                wrapper.setLayoutData((LayoutData)RowFactory.rightAlign());
                result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, wrapper});
            } else {
                result = super.getValue((IMObject)object, column, row);
            }
            return result;
        }
    }
}

