/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.print.exception.PrinterException;
import org.openvpms.print.impl.i18n.PrintMessages;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.report.ReportException;
import org.openvpms.report.i18n.ReportMessages;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.component.print.AbstractPrinter;
import org.openvpms.web.system.ServiceHelper;

public class StatementPrinter
extends AbstractPrinter {
    private final ReporterFactory factory;
    private final DocumentTemplate template;
    private final StatementRules statementRules;
    private final CustomerAccountRules rules;
    private boolean current;
    private boolean includeCompletedCharges;
    private boolean includeFee;
    private FinancialAct closingBalance;
    private Date from;
    private Date to;
    private TemplatedReporter<FinancialAct> reporter;

    public StatementPrinter(Context context, CustomerAccountRules rules, PrinterContext printerContext, ReporterFactory factory) {
        super(printerContext, context);
        this.rules = rules;
        this.factory = factory;
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator("act.customerAccountOpeningBalance", context);
        this.template = locator.getTemplate();
        if (this.template == null) {
            Lookup lookup = ServiceHelper.getLookupService().getLookup("lookup.documentTemplateType", "act.customerAccountOpeningBalance");
            String name = lookup != null ? lookup.getName() : "act.customerAccountOpeningBalance";
            throw new ReportException(ReportMessages.noTemplateForType((String)name));
        }
        this.statementRules = new StatementRules(context.getPractice(), printerContext.getService(), rules);
    }

    public Party getCustomer() {
        return this.getContext().getCustomer();
    }

    public void setPrintCurrent(boolean includeCompletedCharges, boolean includeFee) {
        this.initPrint(true, includeCompletedCharges, includeFee, null, null, null);
    }

    public void setPrintStatement(FinancialAct closingBalance) {
        this.initPrint(false, false, false, closingBalance, null, null);
    }

    public void setPrintRange(Date from, Date to) {
        this.initPrint(false, false, false, null, from, to);
    }

    public void print(DocumentPrinter printer) {
        if (printer == null) {
            throw new PrinterException(PrintMessages.noPrinter());
        }
        TemplatedReporter<FinancialAct> reporter = this.getReporter();
        if (printer.canUseJavaPrintServiceAPI()) {
            reporter.print(this.getProperties(printer));
        } else {
            Document document = reporter.getDocument();
            this.print(document, printer);
        }
        if (this.closingBalance != null && !this.closingBalance.isPrinted()) {
            this.closingBalance.setPrinted(true);
            this.getService().save((IMObject)this.closingBalance);
        }
    }

    public DocumentPrinter getDefaultPrinter() {
        return this.getDefaultPrinter(this.template);
    }

    public Document getDocument() {
        return this.getReporter().getDocument();
    }

    public Document getDocument(String mimeType, boolean email) {
        return this.getReporter().getDocument(mimeType, email);
    }

    public String getDisplayName() {
        return this.getReporter().getDisplayName();
    }

    public TemplatedReporter<FinancialAct> getReporter() {
        if (this.reporter == null) {
            Iterable iterable;
            Date date;
            Party customer = this.getCustomer();
            BigDecimal overdueBalance = BigDecimal.ZERO;
            if (this.current) {
                date = new Date();
                iterable = this.statementRules.getStatementPreview(customer, date, this.includeCompletedCharges, this.includeFee);
                overdueBalance = this.rules.getOverdueBalance(customer, date);
            } else if (this.closingBalance != null) {
                date = this.closingBalance.getActivityStartTime();
                iterable = this.statementRules.getStatement(customer, date);
            } else {
                date = this.to != null ? this.to : new Date();
                Date end = this.to != null ? DateRules.getNextDate((Date)this.to) : null;
                iterable = this.statementRules.getStatementRange(customer, this.from, end);
            }
            iterable = new NonEmptyStatement(iterable, date);
            this.reporter = (TemplatedReporter)this.factory.create(iterable, this.template, TemplatedReporter.class);
            this.reporter.setFields(ReportContextFactory.create((Context)this.getContext()));
            HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
            parameters.put("statementDate", date);
            parameters.put("overdueBalance", overdueBalance);
            this.reporter.setParameters(parameters);
        }
        return this.reporter;
    }

    private void initPrint(boolean current, boolean includeCompletedCharges, boolean includeFee, FinancialAct closingBalance, Date from, Date to) {
        this.current = current;
        this.includeCompletedCharges = includeCompletedCharges;
        this.includeFee = includeFee;
        this.closingBalance = closingBalance;
        this.from = from;
        this.to = to;
        this.reporter = null;
    }

    private class NonEmptyStatement
    implements Iterable<FinancialAct> {
        private final Iterable<FinancialAct> iterable;
        private final Date date;

        public NonEmptyStatement(Iterable<FinancialAct> iterable, Date date) {
            this.iterable = iterable;
            this.date = date;
        }

        @Override
        public Iterator<FinancialAct> iterator() {
            Iterator<FinancialAct> iterator = this.iterable.iterator();
            if (!iterator.hasNext()) {
                BigDecimal balance = StatementPrinter.this.rules.getBalance(StatementPrinter.this.getCustomer(), this.date);
                FinancialAct openingBalance = StatementPrinter.this.rules.createOpeningBalance(StatementPrinter.this.getCustomer(), this.date, balance);
                iterator = Collections.singletonList(openingBalance).iterator();
            }
            return iterator;
        }
    }
}

