/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.account.ReverseConfirmationDialog;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditDialog;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;

public class Reverser {
    private final Party practice;
    private final Party location;
    private final Entity till;
    private final Entity terminal;
    private final User user;
    private final HelpContext help;
    private final IArchetypeService service;
    private final CustomerAccountRules rules;

    public Reverser(Party practice, Party location, Entity till, Entity terminal, User user, HelpContext help) {
        this.practice = practice;
        this.location = location;
        this.till = till;
        this.terminal = terminal;
        this.user = user;
        this.help = help;
        this.service = ServiceHelper.getArchetypeService();
        this.rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
    }

    public void reverse(FinancialAct act, Listener listener) {
        this.reverse(act, null, listener);
    }

    public void reverse(FinancialAct act, FinancialAct tillBalance, Listener listener) {
        if (!"POSTED".equals(act.getStatus())) {
            throw new IllegalArgumentException("Argument 'act' is not POSTED");
        }
        if (this.canReverse(act)) {
            if (this.rules.hasApprovedEFTPOSTransaction(act)) {
                this.reverseWithPaymentEFTItem(act, listener);
            } else if (this.hasPaymentProcessorItem(act)) {
                this.reverseWithPaymentProcessorItem(act, listener);
            } else {
                this.promptReverse(act, tillBalance, listener);
            }
        }
    }

    protected CustomerPaymentEditor getPaymentEditor(FinancialAct act, DefaultLayoutContext context) {
        return new CustomerPaymentEditor(act, null, (LayoutContext)context);
    }

    private void promptReverse(final FinancialAct act, final FinancialAct tillBalance, final Listener listener) {
        String name = this.getDisplayName(act);
        String title = Messages.format((String)"customer.account.reverse.title", (Object[])new Object[]{name});
        String message = Messages.format((String)"customer.account.reverse.message", (Object[])new Object[]{name});
        final String notes = Messages.format((String)"customer.account.reverse.notes", (Object[])new Object[]{this.getDisplayName(act), act.getId()});
        final String reference = Long.toString(act.getId());
        boolean canHide = this.canHideReversal(act);
        final ReverseConfirmationDialog dialog = new ReverseConfirmationDialog(title, message, this.help, notes, reference, canHide);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                FinancialAct reversal;
                String reversalRef;
                String reversalNotes = dialog.getNotes();
                if (StringUtils.isEmpty((CharSequence)reversalNotes)) {
                    reversalNotes = notes;
                }
                if (StringUtils.isEmpty((CharSequence)(reversalRef = dialog.getReference()))) {
                    reversalRef = reference;
                }
                if ((reversal = Reverser.this.reverse(act, reversalNotes, reversalRef, dialog.getHide(), tillBalance)) != null) {
                    listener.reversed(reversal);
                }
            }
        });
        dialog.show();
    }

    private void reverseWithPaymentEFTItem(FinancialAct act, Listener listener) {
        if (!act.isA("act.customerAccountPayment")) {
            this.showCannotReverseDialog(act, "customer.account.reverse.refundEFT");
        } else {
            this.doInteractiveReversal(act, listener);
        }
    }

    private void doInteractiveReversal(FinancialAct act, Listener listener) {
        String notes = Messages.format((String)"customer.account.reverse.notes", (Object[])new Object[]{this.getDisplayName(act), act.getId()});
        FinancialAct reversal = this.rules.createInProgressReversal(act, notes);
        this.editReversal(reversal, listener);
    }

    private void editReversal(final FinancialAct reversal, final Listener listener) {
        LocalContext context = new LocalContext();
        context.setPractice(this.practice);
        context.setLocation(this.location);
        context.setTill(this.till);
        context.setTerminal(this.terminal);
        context.setUser(this.user);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, this.help);
        layoutContext.setEdit(true);
        CustomerPaymentEditor editor = this.getPaymentEditor(reversal, layoutContext);
        editor.setStatus("POSTED");
        editor.setTill(this.till);
        editor.makeSaveableAndPostOnCompletion();
        editor.getItems().editFirst();
        CustomerPaymentEditDialog dialog = new CustomerPaymentEditDialog(editor, (Context)context);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                listener.reversed(reversal);
            }
        });
        dialog.show();
    }

    private void showCannotReverseDialog(FinancialAct act, String key) {
        String displayName = this.getDisplayName(act);
        ((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().titleKey("customer.account.reverse.title", new Object[]{displayName})).messageKey(key, new Object[]{displayName, this.getDisplayName("act.customerAccountPayment")})).show();
    }

    private void reverseWithPaymentProcessorItem(FinancialAct act, Listener listener) {
        if (!act.isA("act.customerAccountPayment")) {
            this.showCannotReverseDialog(act, "customer.account.reverse.refundPP");
        } else {
            this.doInteractiveReversal(act, listener);
        }
    }

    private boolean canReverse(FinancialAct act) {
        IMObjectBean bean;
        List reversal;
        boolean reversed = this.rules.isReversed(act);
        if (reversed && !(reversal = (bean = this.service.getBean((IMObject)act)).getValues("reversal", ActRelationship.class)).isEmpty()) {
            Reference target = ((ActRelationship)reversal.get(0)).getTarget();
            String reversalDisplayName = this.getDisplayName(target.getArchetype());
            String displayName = this.getDisplayName(act);
            ((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().titleKey("customer.account.reverse.title", new Object[]{displayName})).messageKey("customer.account.reversed.message", new Object[]{displayName, reversalDisplayName, target.getId()})).show();
        }
        return !reversed;
    }

    private boolean hasPaymentProcessorItem(FinancialAct act) {
        boolean result = false;
        if (act.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            List relationships = bean.getValues("items", Relationship.class, Predicates.targetIsA((String[])new String[]{"act.customerAccountPaymentPP", "act.customerAccountRefundPP"}));
            result = !relationships.isEmpty();
        }
        return result;
    }

    private String getDisplayName(String archetype) {
        return DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.service);
    }

    private String getDisplayName(FinancialAct act) {
        return DescriptorHelper.getDisplayName((IMObject)act, (ArchetypeService)this.service);
    }

    private FinancialAct reverse(FinancialAct act, String notes, String reference, boolean hide, FinancialAct tillBalance) {
        FinancialAct reversal = null;
        try {
            reversal = this.rules.reverse(act, new Date(), notes, reference, hide, tillBalance);
        }
        catch (Exception exception) {
            String title = Messages.format((String)"customer.account.reverse.failed", (Object[])new Object[]{this.getDisplayName(act)});
            ErrorHelper.show((String)title, (Throwable)exception);
        }
        return reversal;
    }

    private boolean canHideReversal(FinancialAct act) {
        if (!this.rules.isHidden((Act)act)) {
            StatementRules statementRules = new StatementRules(this.practice, this.service, this.rules);
            IMObjectBean bean = this.service.getBean((IMObject)act);
            Party customer = (Party)bean.getTarget("customer", Party.class);
            return customer != null && !statementRules.hasStatement(customer, act.getActivityStartTime());
        }
        return false;
    }

    public static interface Listener {
        public void reversed(FinancialAct var1);
    }
}

