/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.report.TemplatedReporter;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.component.print.InteractivePrinter;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.customer.account.StatementPrinter;

public class InteractiveStatementPrinter
extends InteractivePrinter {
    private SelectField issuedSelector;

    public InteractiveStatementPrinter(StatementPrinter printer, Context context, HelpContext help) {
        super((Printer)printer, context, help);
    }

    protected StatementPrinter getPrinter() {
        return (StatementPrinter)super.getPrinter();
    }

    protected PrintDialog createDialog() {
        return new StatementPrintDialog(this.getPrinter(), this.getTitle(), this.getContext().getLocation(), this.getHelpContext());
    }

    protected String getTitle() {
        String title = super.getTitle();
        if (title != null) {
            return title;
        }
        return Messages.format((String)"imobject.print.title", (Object[])new Object[]{this.getDisplayName()});
    }

    protected void show(MailDialog dialog) {
        EmailTemplate emailTemplate;
        super.show(dialog);
        MailEditor editor = dialog.getMailEditor();
        StatementPrinter printer = this.getPrinter();
        TemplatedReporter<FinancialAct> reporter = printer.getReporter();
        editor.setObject((Object)printer.getCustomer());
        DocumentTemplate template = reporter.getTemplate();
        if (template != null && (emailTemplate = template.getEmailTemplate()) != null) {
            editor.setContent(emailTemplate);
        }
    }

    private class StatementPrintDialog
    extends PrintDialog {
        private final StatementPrinter printer;
        private final List<FinancialAct> closingBalances;
        private final RadioButton current;
        private final CheckBox complete;
        private final CheckBox fee;
        private final RadioButton issued;
        private final RadioButton range;
        private final DateRange dates;
        private final FocusGroup focusGroup;

        public StatementPrintDialog(StatementPrinter printer, String title, Party location, HelpContext help) {
            super(title, true, true, false, location, help);
            this.dates = new DateRange(false);
            this.printer = printer;
            this.closingBalances = this.getClosingBalances();
            ButtonGroup group = new ButtonGroup();
            this.current = ButtonFactory.create((String)"customer.account.statement.current", (ButtonGroup)group);
            this.current.setSelected(true);
            this.complete = CheckBoxFactory.create((String)"customer.account.statement.complete");
            this.fee = CheckBoxFactory.create((String)"customer.account.statement.fee");
            this.issued = ButtonFactory.create((String)"customer.account.statement.issued", (ButtonGroup)group);
            if (this.closingBalances.isEmpty()) {
                this.issued.setEnabled(false);
            }
            this.range = ButtonFactory.create((String)"customer.account.statement.range", (ButtonGroup)group);
            this.focusGroup = new FocusGroup("StatementPrintDialog");
            this.getFocusGroup().add(0, this.focusGroup);
        }

        protected void onOK() {
            if (this.setParameters()) {
                super.onOK();
            }
        }

        protected void onPreview() {
            if (this.setParameters()) {
                InteractiveStatementPrinter.this.preview();
            }
        }

        protected void onMail() {
            if (this.setParameters()) {
                InteractiveStatementPrinter.this.mail(this);
            }
        }

        protected void doLayout(Component container) {
            ComponentGrid grid = new ComponentGrid();
            grid.add(new Component[]{this.current, this.complete});
            grid.add(new Component[]{LabelFactory.create(), this.fee});
            ActionListener currentListener = new ActionListener(){

                public void onAction(ActionEvent event) {
                    StatementPrintDialog.this.current.setSelected(true);
                }
            };
            this.complete.addActionListener((nextapp.echo2.app.event.ActionListener)currentListener);
            this.fee.addActionListener((nextapp.echo2.app.event.ActionListener)currentListener);
            this.focusGroup.add((Component)this.current);
            if (!this.closingBalances.isEmpty()) {
                DefaultListModel model = new DefaultListModel(this.closingBalances.toArray());
                InteractiveStatementPrinter.this.issuedSelector = SelectFieldFactory.create((ListModel)model);
                InteractiveStatementPrinter.this.issuedSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        StatementPrintDialog.this.issued.setSelected(true);
                    }
                });
                ListCellRenderer & Serializable renderer = (ListCellRenderer & Serializable)(component, o, i) -> DateFormatter.formatDate((Date)((FinancialAct)o).getActivityStartTime(), (boolean)false);
                InteractiveStatementPrinter.this.issuedSelector.setCellRenderer((ListCellRenderer)renderer);
                grid.add(new Component[]{this.issued, InteractiveStatementPrinter.this.issuedSelector});
                this.focusGroup.add((Component)this.issued);
                this.focusGroup.add((Component)InteractiveStatementPrinter.this.issuedSelector);
            }
            grid.add(new Component[]{this.range, this.dates.getComponent()});
            this.focusGroup.add((Component)this.range);
            this.focusGroup.add(this.dates.getFocusGroup());
            container.add((Component)grid.createGrid());
            super.doLayout(container);
        }

        private boolean setParameters() {
            boolean set = true;
            if (this.current.isSelected()) {
                this.printer.setPrintCurrent(this.complete.isSelected(), this.fee.isSelected());
            } else if (this.issued.isSelected() && InteractiveStatementPrinter.this.issuedSelector != null && InteractiveStatementPrinter.this.issuedSelector.getSelectedIndex() != -1) {
                FinancialAct closing = this.closingBalances.get(InteractiveStatementPrinter.this.issuedSelector.getSelectedIndex());
                this.printer.setPrintStatement(closing);
            } else if (this.range.isSelected()) {
                this.printer.setPrintRange(this.dates.getFrom(), this.dates.getTo());
            } else {
                set = false;
            }
            return set;
        }

        private List<FinancialAct> getClosingBalances() {
            ArchetypeQuery query = CustomerAccountQueryFactory.createQuery((Party)InteractiveStatementPrinter.this.getContext().getCustomer(), (String)"act.customerAccountClosingBalance");
            query.add((IConstraint)Constraints.sort((String)"startTime", (boolean)false));
            query.add((IConstraint)Constraints.sort((String)"id", (boolean)false));
            query.setMaxResults(-1);
            return QueryHelper.query((ArchetypeQuery)query);
        }
    }
}

