/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.account.AccountActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;

public class AdjustmentActEditor
extends AccountActEditor {
    public AdjustmentActEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        this.initParticipant("location", (IMObject)context.getContext().getLocation());
        this.recalculateTax();
        Property amount = this.getProperty("amount");
        amount.addModifiableListener(modifiable -> this.recalculateTax());
    }

    private void recalculateTax() {
        CustomerTaxRules rules;
        BigDecimal tax;
        FinancialAct act = this.getObject();
        BigDecimal previousTax = act.getTaxAmount();
        Context context = this.getLayoutContext().getContext();
        Party practice = context.getPractice();
        if (practice != null && (tax = (rules = new CustomerTaxRules(practice, (IArchetypeService)ServiceHelper.getArchetypeService())).calculateTax(act)).compareTo(previousTax) != 0) {
            Property property = this.getProperty("tax");
            property.refresh();
        }
    }
}

