/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceUpdater;
import org.openvpms.archetype.tools.account.AccountBalanceTool;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;
import org.openvpms.web.workspace.customer.account.InteractiveStatementPrinter;
import org.openvpms.web.workspace.customer.account.Reverser;
import org.openvpms.web.workspace.customer.account.StatementPrinter;
import org.openvpms.web.workspace.customer.account.payment.AdminCustomerPaymentEditDialog;
import org.openvpms.web.workspace.customer.account.payment.AdminCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.charge.AbstractChargeCRUDWindow;
import org.springframework.transaction.PlatformTransactionManager;

public class AccountCRUDWindow
extends AbstractChargeCRUDWindow {
    private static final String REVERSE_ID = "button.reverse";
    private static final String STATEMENT_ID = "button.statement";
    private static final String ADJUST_ID = "button.adjust";
    private static final String CHECK_ID = "button.check";
    private static final String HIDE_ID = "button.hide";
    private static final String UNHIDE_ID = "button.unhide";

    public AccountCRUDWindow(Archetypes<FinancialAct> archetypes, Context context, HelpContext help) {
        super(archetypes, context, help);
    }

    public void setObject(FinancialAct object) {
        super.setObject((Act)object);
        this.updateContext("act.customerAccountChargesInvoice", (IMObject)object);
    }

    protected void print(final FinancialAct object) {
        if (this.getRules().isHidden((Act)object)) {
            String displayName = this.getDisplayName((IMObject)object);
            String title = Messages.format((String)"customer.account.printhidden.title", (Object[])new Object[]{displayName});
            String message = Messages.format((String)"customer.account.printhidden.message", (Object[])new Object[]{displayName, object.getId()});
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    AccountCRUDWindow.super.print((Act)object);
                }
            });
        } else {
            super.print((Act)object);
        }
    }

    protected void mail(final FinancialAct object) {
        if (this.getRules().isHidden((Act)object)) {
            String displayName = this.getDisplayName((IMObject)object);
            String title = Messages.format((String)"customer.account.mailhidden.title", (Object[])new Object[]{displayName});
            String message = Messages.format((String)"customer.account.mailhidden.message", (Object[])new Object[]{displayName, object.getId()});
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    AccountCRUDWindow.super.mail((Act)object);
                }
            });
        } else {
            super.mail((Act)object);
        }
    }

    protected void layoutButtons(ButtonSet buttons) {
        boolean admin = UserHelper.isAdmin((User)this.getContext().getUser());
        if (admin) {
            buttons.add("button.edit", this.action("act.customerAccountPayment", this::administerPayment, act -> this.getActions().canAdminPayment((FinancialAct)act, this.getContext().getUser()), "customer.account.payment.edit"));
        }
        buttons.add(STATEMENT_ID, this::onStatement);
        buttons.add(ADJUST_ID, this::onAdjust);
        buttons.add(REVERSE_ID, this.action(this::onReverse));
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        if (admin) {
            buttons.add(CHECK_ID, this::onCheck);
            buttons.add(HIDE_ID, this.action(this::onHide));
            buttons.add(UNHIDE_ID, this.action(this::onUnhide));
        }
        buttons.add(this.createEnableRemindersButton());
        buttons.add(this.createDisableRemindersButton());
        this.enableButtons(buttons, true);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        User user = this.getContext().getUser();
        buttons.setEnabled("button.edit", enable && this.getActions().canAdminPayment((FinancialAct)this.getObject(), user));
        buttons.setEnabled(REVERSE_ID, enable);
        this.enablePrintPreview(buttons, enable);
        buttons.setEnabled(CHECK_ID, enable);
        this.enableDisableReminderButtons(buttons, enable);
    }

    protected void onStatement() {
        Context context = this.getContext();
        Party customer = context.getCustomer();
        if (customer != null) {
            PrinterContext printerContext = ((PrinterContextFactory)ServiceHelper.getBean(PrinterContextFactory.class)).create();
            StatementPrinter printer = new StatementPrinter(context, (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class), printerContext, (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class));
            HelpContext help = this.getHelpContext().subtopic("statement");
            InteractiveStatementPrinter interactive = new InteractiveStatementPrinter(printer, context, help);
            interactive.setMailContext((MailContext)new BillingCustomerMailContext(context, help));
            interactive.print();
        }
    }

    protected void onReverse(FinancialAct act) {
        String status = act.getStatus();
        if (act.isA(new String[]{"act.customerAccountOpeningBalance", "act.customerAccountClosingBalance"}) || !"POSTED".equals(status)) {
            this.showStatusError((Act)act, "customer.account.noreverse.title", "customer.account.noreverse.message");
        } else {
            Context context = this.getContext();
            Reverser reverser = new Reverser(context.getPractice(), context.getLocation(), context.getTill(), context.getTerminal(), context.getUser(), this.getHelpContext().subtopic("reverse"));
            reverser.reverse(act, reversal -> this.onReverseCompleted(act, reversal));
        }
    }

    protected void onAdjust() {
        Party customer = this.getContext().getCustomer();
        CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        if (customer != null) {
            Object[] shortNames = new String[]{"act.customerAccountDebitAdjust", "act.customerAccountCreditAdjust", "act.customerAccountBadDebt"};
            if (!rules.hasAccountActs(customer)) {
                shortNames = (String[])ArrayUtils.insert((int)0, (Object[])shortNames, (Object[])new String[]{"act.customerAccountInitialBalance"});
            }
            Archetypes archetypes = Archetypes.create((String[])shortNames, FinancialAct.class, (String)Messages.get((String)"customer.account.createtype"));
            this.onCreate(archetypes);
        }
    }

    protected void onCheck() {
        Party customer = this.getContext().getCustomer();
        if (customer != null) {
            try {
                CustomerAccountRules rules = this.getRules();
                BigDecimal expected = rules.getDefinitiveBalance(customer);
                BigDecimal actual = rules.getBalance(customer);
                if (expected.compareTo(actual) == 0) {
                    String title = Messages.get((String)"customer.account.balancecheck.title");
                    String message = Messages.get((String)"customer.account.balancecheck.ok");
                    InformationDialog.show((String)title, (String)message);
                } else {
                    String message = Messages.format((String)"customer.account.balancecheck.error", (Object[])new Object[]{NumberFormatter.formatCurrency((Number)expected), NumberFormatter.formatCurrency((Number)actual)});
                    this.confirmRegenerate(message, customer);
                }
            }
            catch (CustomerAccountRuleException exception) {
                String message = Messages.format((String)"customer.account.balancecheck.acterror", (Object[])new Object[]{exception.getMessage()});
                this.confirmRegenerate(message, customer);
            }
        }
    }

    protected void onEditCompleted(IMObjectEditor editor, boolean isNew) {
        if (editor.isSaved()) {
            this.onRefresh(this.getObject());
        }
    }

    protected void administerPayment(FinancialAct payment) {
        if (this.getRules().hasClearedTillBalance(payment)) {
            ErrorDialog.show((String)Messages.get((String)"customer.account.payment.clearedtill.title"), (String)Messages.get((String)"customer.account.payment.clearedtill.message"));
        } else {
            HelpContext edit = this.createEditTopic((IMObject)payment);
            LayoutContext context = this.createLayoutContext(edit);
            final AdminCustomerPaymentEditor editor = new AdminCustomerPaymentEditor(payment, null, context);
            editor.getComponent();
            AdminCustomerPaymentEditDialog dialog = new AdminCustomerPaymentEditDialog(editor, context.getContext());
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    AccountCRUDWindow.this.onEditCompleted((IMObjectEditor)editor, false);
                }
            });
            dialog.show();
        }
    }

    private void onHide(FinancialAct act) {
        this.getRules().setHidden(act, true);
        this.onRefresh(this.getObject());
    }

    private void onUnhide(FinancialAct act) {
        this.getRules().setHidden(act, false);
        this.onRefresh(this.getObject());
    }

    private void onReverseCompleted(FinancialAct act, FinancialAct reversal) {
        this.onRefresh((IMObject)act);
        if (!this.getRules().isHidden((Act)reversal)) {
            this.print(reversal);
        }
    }

    private void confirmRegenerate(String message, final Party customer) {
        String title = Messages.get((String)"customer.account.balancecheck.title");
        HelpContext check = this.getHelpContext().subtopic("check");
        ConfirmationDialog dialog = new ConfirmationDialog(title, message, check);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                AccountCRUDWindow.this.regenerate(customer);
            }
        });
        dialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerate(Party customer) {
        try {
            IArchetypeService service = ServiceHelper.getArchetypeService((boolean)false);
            CustomerBalanceUpdater updater = (CustomerBalanceUpdater)ServiceHelper.getBean(CustomerBalanceUpdater.class);
            PlatformTransactionManager transactionManager = (PlatformTransactionManager)ServiceHelper.getBean(PlatformTransactionManager.class);
            AccountBalanceTool tool = new AccountBalanceTool(service, updater, transactionManager);
            tool.generate(customer);
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        finally {
            this.onRefresh(this.getObject());
        }
    }
}

