/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.system.ServiceHelper;

public class StockOnHand {
    private final StockRules rules;
    private final Map<Key, Stock> onHand = new HashMap<Key, Stock>();
    private final Map<FinancialAct, State> states = new HashMap<FinancialAct, State>();

    public StockOnHand(StockRules rules) {
        this.rules = rules;
    }

    public BigDecimal getAvailableStock(FinancialAct act) {
        Stock stock;
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        Reference product = bean.getTargetRef("product");
        Reference stockLocation = bean.getTargetRef("stockLocation");
        State state = this.getState(act);
        Key key = null;
        if (product != null && stockLocation != null) {
            key = new Key(product, stockLocation);
        }
        if (state.key == null) {
            state.key = key;
        } else if (!state.key.equals(key)) {
            stock = this.onHand.get(state.key);
            if (stock != null) {
                stock.remove(state);
            }
            state.key = key;
        }
        if (key != null) {
            stock = this.getStock(key);
            stock.add(state);
            return stock.getAvailableStock();
        }
        return null;
    }

    public BigDecimal getStock(Reference product, Reference stockLocation) {
        Key key = new Key(product, stockLocation);
        Stock stock = this.getStock(key);
        return stock.getStock();
    }

    public void remove(FinancialAct act) {
        Stock stock;
        State state = this.states.remove(act);
        if (state != null && (stock = this.onHand.get(state.key)) != null) {
            stock.remove(state);
        }
    }

    public void clear() {
        this.states.clear();
        this.onHand.clear();
    }

    private State getState(FinancialAct act) {
        State state = this.states.get(act);
        if (state == null) {
            state = new State(act);
            this.states.put(act, state);
        }
        return state;
    }

    private Stock getStock(Key key) {
        Stock stock = this.onHand.get(key);
        if (stock == null) {
            stock = new Stock(this.rules.getStock(key.product, key.stockLocation));
            this.onHand.put(key, stock);
        }
        return stock;
    }

    private static class Stock {
        private final Set<State> states = new HashSet<State>();
        private BigDecimal stock;

        public Stock(BigDecimal stock) {
            this.stock = stock;
        }

        public void add(State state) {
            this.states.add(state);
        }

        public void remove(State state) {
            this.stock = this.stock.add(state.getSaved());
            this.states.remove(state);
        }

        public BigDecimal getStock() {
            return this.stock;
        }

        public BigDecimal getAvailableStock() {
            BigDecimal result = this.stock;
            for (State state : this.states) {
                result = result.subtract(state.getQuantity());
            }
            return result;
        }
    }

    private static class State {
        private final FinancialAct act;
        private final BigDecimal saved;
        private Key key;

        public State(FinancialAct act) {
            this.act = act;
            this.saved = act.isNew() ? BigDecimal.ZERO : this.getCurrent();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof State && ((State)obj).act == this.act;
        }

        public int hashCode() {
            return this.act.hashCode();
        }

        public BigDecimal getSaved() {
            return this.saved;
        }

        public BigDecimal getQuantity() {
            return this.getCurrent().subtract(this.saved);
        }

        public BigDecimal getCurrent() {
            BigDecimal current = this.act.getQuantity();
            if (current == null) {
                current = BigDecimal.ZERO;
            }
            return current;
        }
    }

    private static class Key {
        private final Reference product;
        private final Reference stockLocation;

        public Key(Reference product, Reference stockLocation) {
            this.product = product;
            this.stockLocation = stockLocation;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.product.hashCode()).append(this.stockLocation.hashCode()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.product.equals((Object)key.product) && this.stockLocation.equals((Object)key.stockLocation);
            }
            return false;
        }
    }
}

