/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.ComparatorUtils;
import org.openvpms.component.business.domain.im.party.Contact;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextMailContext;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.ToAddressFormatter;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.document.CustomerPatientDocumentBrowser;

public class CustomerMailContext
extends ContextMailContext {
    private final IArchetypeService service;
    private final boolean useDefaultToAddress;
    private AddressState toAddressState;

    public CustomerMailContext(Context context) {
        this(context, (String)null);
    }

    public CustomerMailContext(Context context, String fromPurpose) {
        this(context, fromPurpose, false);
    }

    public CustomerMailContext(Context context, boolean useDefaultToAddress) {
        this(context, null, useDefaultToAddress);
    }

    public CustomerMailContext(Context context, String fromPurpose, boolean useDefaultToAddress) {
        super(context, fromPurpose);
        this.useDefaultToAddress = useDefaultToAddress;
        this.service = ServiceHelper.getArchetypeService();
    }

    public CustomerMailContext(Context context, HelpContext help) {
        this(context, null, help);
    }

    public CustomerMailContext(Context context, String fromPurpose, HelpContext help) {
        this(context, fromPurpose, false, help);
    }

    public CustomerMailContext(Context context, boolean useDefaultToAddress, HelpContext help) {
        this(context, null, useDefaultToAddress, help);
    }

    public CustomerMailContext(Context context, String fromPurpose, boolean useDefaultToAddress, HelpContext help) {
        this(context, fromPurpose, useDefaultToAddress);
        DefaultLayoutContext layout = new DefaultLayoutContext(context, help);
        this.setAttachmentBrowserFactory(mailContext -> {
            CustomerPatientDocumentBrowser result = null;
            Party customer = this.getCustomer();
            Party patient = this.getPatient();
            if (customer != null || patient != null) {
                result = new CustomerPatientDocumentBrowser(customer, patient, (LayoutContext)layout);
            }
            return result;
        });
    }

    public Party getCustomer() {
        return this.getContext().getCustomer();
    }

    public Party getPatient() {
        return this.getContext().getPatient();
    }

    public Party getLocation() {
        return this.getContext().getLocation();
    }

    public MailContext.Addresses getToAddresses() {
        return this.getToAddressState().getAddresses();
    }

    public AddressFormatter getToAddressFormatter() {
        return new ReferringAddressFormatter();
    }

    public static CustomerMailContext create(Act act, Context context, HelpContext help) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        Party customer = CustomerMailContext.getParty(bean, "customer", context);
        Party patient = CustomerMailContext.getParty(bean, "patient", context);
        return CustomerMailContext.create(customer, patient, context, help);
    }

    public static CustomerMailContext create(Party customer, Party patient, Context context, HelpContext help) {
        CustomerMailContext result = null;
        if (customer != null || patient != null) {
            LocalContext local = LocalContext.copy((Context)context);
            local.setCustomer(customer);
            local.setPatient(patient);
            result = new CustomerMailContext((Context)local, help);
        }
        return result;
    }

    protected AddressState getToAddressState() {
        if (this.toAddressState == null || this.toAddressesOutOfDate(this.toAddressState)) {
            this.toAddressState = this.createToAddressState(new AddressStateBuilder());
        }
        return this.toAddressState;
    }

    protected boolean toAddressesOutOfDate(AddressState state) {
        return !state.matches("party.customerperson", this.getCustomer()) || !state.matches("party.patientpet", this.getPatient());
    }

    protected AddressState createToAddressState(AddressStateBuilder builder) {
        Party customer = this.getCustomer();
        builder.addParty("party.customerperson", customer);
        if (customer != null) {
            List contacts = ContactHelper.getEmailContacts((Party)customer, (ArchetypeService)this.service);
            builder.addContacts(contacts);
            if (builder.getPreferred() == null && this.useDefaultToAddress && !contacts.isEmpty()) {
                builder.setPreferred((org.openvpms.component.model.party.Contact)contacts.get(0));
            }
            Party patient = this.getPatient();
            builder.addParty("party.patientpet", patient);
            if (patient != null) {
                builder.addContacts(this.getReferralAddresses(patient));
            }
        }
        return builder.build();
    }

    protected List<org.openvpms.component.model.party.Contact> getReferralAddresses(Party patient) {
        ArrayList<org.openvpms.component.model.party.Contact> result = new ArrayList<org.openvpms.component.model.party.Contact>();
        IMObjectBean bean = this.service.getBean((IMObject)patient);
        HashSet<Reference> practices = new HashSet<Reference>();
        for (IMObject referral : bean.getTargets("referrals", Policies.active((Date)new Date(), (boolean)false))) {
            if (!(referral instanceof Party)) continue;
            if (referral.isActive()) {
                result.addAll(ContactHelper.getEmailContacts((Party)((Party)referral), (ArchetypeService)this.service));
            }
            if (!referral.isA("party.supplierVeterinarian")) continue;
            IMObjectBean vet = this.service.getBean(referral);
            for (Reference ref : vet.getSourceRefs("practices")) {
                if (practices.contains(ref)) continue;
                practices.add(ref);
                Party practice = (Party)IMObjectHelper.getObject((Reference)ref, (Context)this.getContext());
                if (practice == null || !practice.isActive()) continue;
                result.addAll(ContactHelper.getEmailContacts((Party)practice, (ArchetypeService)this.service));
            }
        }
        return result;
    }

    private static Party getParty(IMObjectBean bean, String node, Context context) {
        if (bean.hasNode(node)) {
            return (Party)IMObjectHelper.getObject((Reference)bean.getTargetRef(node), (Context)context);
        }
        return null;
    }

    private static Party getParty(org.openvpms.component.model.party.Contact contact) {
        return ((Contact)contact).getParty();
    }

    private static class ReferringAddressFormatter
    extends ToAddressFormatter {
        private ReferringAddressFormatter() {
        }

        public String getType(org.openvpms.component.model.party.Contact contact) {
            Party party;
            String type = super.getType(contact);
            if (type != null && (party = CustomerMailContext.getParty(contact)) != null && party.isA(new String[]{"party.supplierVeterinarian", "party.supplierVeterinaryPractice"})) {
                type = Messages.format((String)"mail.type.referring", (Object[])new Object[]{type});
            }
            return type;
        }
    }

    protected static class AddressStateBuilder {
        private final List<AddressState.PartyContacts> parties = new ArrayList<AddressState.PartyContacts>();
        private final List<org.openvpms.component.model.party.Contact> contacts = new ArrayList<org.openvpms.component.model.party.Contact>();
        private org.openvpms.component.model.party.Contact preferred;

        protected AddressStateBuilder() {
        }

        public void addParty(String archetype, Party party) {
            this.parties.add(new AddressState.PartyContacts(party, archetype));
        }

        public void addContacts(List<org.openvpms.component.model.party.Contact> contacts) {
            this.contacts.addAll(contacts);
        }

        public void setPreferred(org.openvpms.component.model.party.Contact preferred) {
            this.preferred = preferred;
        }

        public org.openvpms.component.model.party.Contact getPreferred() {
            return this.preferred;
        }

        public AddressState build() {
            if (this.contacts.size() > 1) {
                this.sort(this.contacts);
            }
            return new AddressState(new MailContext.Addresses(this.contacts, this.preferred), this.parties);
        }

        private void sort(List<org.openvpms.component.model.party.Contact> contacts) {
            Comparator comparator = ComparatorUtils.nullHighComparator(null);
            contacts.sort((o1, o2) -> comparator.compare(this.getPartyName((org.openvpms.component.model.party.Contact)o1), this.getPartyName((org.openvpms.component.model.party.Contact)o2)));
        }

        private String getPartyName(org.openvpms.component.model.party.Contact contact) {
            return CustomerMailContext.getParty(contact).getName();
        }
    }

    protected static class AddressState {
        private final List<PartyContacts> parties;
        private final MailContext.Addresses addresses;

        public AddressState(MailContext.Addresses addresses, List<PartyContacts> parties) {
            this.addresses = addresses;
            this.parties = parties;
        }

        public MailContext.Addresses getAddresses() {
            return this.addresses;
        }

        public boolean matches(String archetype, Party party) {
            boolean matches = false;
            for (PartyContacts handle : this.parties) {
                if (!handle.archetype.equals(archetype)) continue;
                matches = handle.matches(party);
                break;
            }
            return matches;
        }

        static class PartyContacts {
            private final Party party;
            private final long version;
            private final String archetype;

            public PartyContacts(Party party, String archetype) {
                this.party = party;
                this.version = this.getVersion(party);
                this.archetype = archetype;
            }

            public boolean matches(Party other) {
                return Objects.equals(this.party, other) && this.version == this.getVersion(other);
            }

            private long getVersion(Party party) {
                return party != null ? party.getVersion() : -1L;
            }
        }
    }
}

