/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.alert;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.layout.RowLayoutData;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.AlertDialog;
import org.openvpms.web.component.alert.AlertManager;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.alert.AlertHelper;
import org.openvpms.web.workspace.alert.AlertsViewer;

public class AlertSummary {
    private final Party party;
    private final String key;
    private final Context context;
    private final HelpContext help;
    private final Column container;
    private List<Alert> alerts;
    private int showCount = 4;

    public AlertSummary(Party party, List<Alert> alerts, Context context, HelpContext help) {
        this(party, alerts, "alerts.title", context, help);
    }

    public AlertSummary(Party party, List<Alert> alerts, String key, Context context, HelpContext help) {
        this.party = party;
        this.alerts = alerts;
        this.key = key;
        this.context = context;
        this.help = help.subtopic("alert");
        this.container = ColumnFactory.create();
    }

    public void setShowCount(int count) {
        this.showCount = count;
    }

    public Component getComponent() {
        this.doLayout();
        return this.container;
    }

    protected void doLayout() {
        this.container.removeAll();
        if (!this.alerts.isEmpty()) {
            Row title = RowFactory.create((Component[])new Component[]{LabelFactory.create((String)this.key, (String)"bold")});
            this.container.add((Component)title);
            for (int i = 0; i < this.alerts.size() && i < this.showCount; ++i) {
                Alert element = this.alerts.get(i);
                this.container.add((Component)this.getButton(element));
            }
            if (this.alerts.size() > this.showCount) {
                Button viewAll = ButtonFactory.create((String)"alerts.viewall", (String)"small", this::onShowAll);
                Row right = RowFactory.create((Component[])new Component[]{viewAll});
                RowLayoutData rightLayout = new RowLayoutData();
                rightLayout.setAlignment(Alignment.ALIGN_RIGHT);
                rightLayout.setWidth(new Extent(100, 2));
                right.setLayoutData((LayoutData)rightLayout);
                Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{title, right});
                this.container.add((Component)row, 0);
            }
        } else {
            this.container.setVisible(false);
        }
    }

    protected void onShowAll() {
        AlertsViewer viewer = new AlertsViewer(this.party, this.alerts, this.context, this.help);
        viewer.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                AlertSummary.this.refresh();
            }
        });
        viewer.show();
    }

    protected Button getButton(Alert alert) {
        return AlertHelper.createButton(alert, () -> {
            AlertDialog dialog = new AlertDialog(alert, this.context, this.help);
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    AlertSummary.this.refresh();
                }
            });
            dialog.show();
        });
    }

    private void refresh() {
        this.alerts = ((AlertManager)ServiceHelper.getBean(AlertManager.class)).getAlerts(this.party);
        this.doLayout();
    }
}

