/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.type;

import java.math.BigDecimal;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class DiscountTypeEditor
extends AbstractIMObjectEditor {
    private static final String TYPE = "type";
    private static final String DISCOUNT_FIXED = "discountFixed";
    private static final String RATE = "rate";

    public DiscountTypeEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        this.getProperty(TYPE).addModifiableListener(modifiable -> {
            if ("FIXED".equals(this.getType())) {
                this.setDiscountFixed(false);
            }
        });
    }

    public void setType(String type) {
        this.getProperty(TYPE).setValue((Object)type);
    }

    public String getType() {
        return this.getProperty(TYPE).getString();
    }

    public void setDiscountFixed(boolean discountFixed) {
        this.getProperty(DISCOUNT_FIXED).setValue((Object)discountFixed);
    }

    public void setRate(BigDecimal rate) {
        this.getProperty(RATE).setValue((Object)rate);
    }

    public IMObjectEditor newInstance() {
        return new DiscountTypeEditor(this.reload(this.getObject()), this.getParent(), this.newLayoutContext());
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateFixed(validator);
    }

    private boolean validateFixed(Validator validator) {
        Property discountFixed;
        boolean valid = true;
        if ("FIXED".equals(this.getProperty(TYPE).getString()) && (discountFixed = this.getProperty(DISCOUNT_FIXED)).getBoolean()) {
            valid = false;
            String message = Messages.get((String)"discount.fixedWithdiscountFixedUnsupported");
            validator.add((Modifiable)discountFixed, new ValidatorError(message));
        }
        return valid;
    }
}

