/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template.paymentprocessor;

import java.math.BigDecimal;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.customer.CustomerReferenceEditor;
import org.openvpms.web.component.im.edit.DefaultIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.SMSTemplateSampler;
import org.openvpms.web.workspace.admin.template.paymentprocessor.PaymentProcessorSMSEvaluator;

public class SMSPaymentProcessorTemplateSampler
extends SMSTemplateSampler {
    private final PaymentProcessorSMSEvaluator evaluator;
    private final Property customer;
    private final Property location;
    private final Property processor;
    private final Property description;
    private final Property amount;
    private final Property url;
    private final ArchetypeService service = ServiceHelper.getArchetypeService();

    public SMSPaymentProcessorTemplateSampler(Entity template, LayoutContext layoutContext) {
        super(template, layoutContext);
        Context context = layoutContext.getContext();
        this.evaluator = new PaymentProcessorSMSEvaluator(context.getPractice(), (SMSTemplateEvaluator)ServiceHelper.getBean(SMSTemplateEvaluator.class), this.service, ServiceHelper.getLookupService());
        ModifiableListener listener = modifiable -> this.evaluate();
        this.customer = SimpleProperty.newProperty().name("customer").type(Reference.class).value(context.getCustomer() != null ? context.getCustomer().getObjectReference() : null).archetypeRange(new String[]{"party.customerperson"}).displayName(DescriptorHelper.getDisplayName((String)"act.customerAccountPaymentPP", (String)"customer", (ArchetypeService)this.service)).listener(listener).required().build();
        this.location = SimpleProperty.newProperty().name("location").type(Reference.class).value(context.getLocation() != null ? context.getLocation().getObjectReference() : null).archetypeRange(new String[]{"party.organisationLocation"}).displayName(DescriptorHelper.getDisplayName((String)"act.customerAccountPaymentPP", (String)"location", (ArchetypeService)this.service)).listener(listener).required().build();
        this.processor = SimpleProperty.newProperty().name("paymentProcessor").type(Reference.class).archetypeRange(new String[]{"entity.paymentProcessor*"}).displayName(DescriptorHelper.getDisplayName((String)"act.customerAccountPaymentPP", (String)"paymentProcessor", (ArchetypeService)this.service)).listener(listener).required().build();
        this.description = SimpleProperty.newProperty().name("description").value((Object)"deposit for surgery").displayName(DescriptorHelper.getDisplayName((String)"act.customerAccountPaymentPP", (String)"description", (ArchetypeService)this.service)).listener(listener).required().build();
        this.amount = SimpleProperty.newProperty().name("amount").value((Object)new BigDecimal("100.00")).displayName(DescriptorHelper.getDisplayName((String)"act.customerAccountPaymentPP", (String)"amount", (ArchetypeService)this.service)).listener(listener).required().build();
        this.url = SimpleProperty.newProperty().name("url").value((Object)"https://testpaymentprocessor.com/payment/123456789").displayName(DescriptorHelper.getDisplayName((String)"act.customerAccountPaymentPP", (String)"url", (ArchetypeService)this.service)).listener(listener).required().build();
    }

    @Override
    protected void layoutFields(ComponentGrid grid, FocusGroup group, LayoutContext context) {
        CustomerReferenceEditor customerSelector = new CustomerReferenceEditor(this.customer, null, context);
        DefaultIMObjectReferenceEditor locationSelector = new DefaultIMObjectReferenceEditor(this.location, null, context);
        DefaultIMObjectReferenceEditor processorSelector = new DefaultIMObjectReferenceEditor(this.processor, null, context);
        Component descriptionComponent = context.getComponentFactory().create(this.description);
        Component amountComponent = context.getComponentFactory().create(this.amount);
        Component urlComponent = context.getComponentFactory().create(this.url);
        grid.add(new Component[]{LabelFactory.text((String)this.customer.getDisplayName()), customerSelector.getComponent(), LabelFactory.text((String)this.location.getDisplayName()), locationSelector.getComponent()});
        grid.add(new Component[]{LabelFactory.text((String)this.processor.getDisplayName()), processorSelector.getComponent(), LabelFactory.text((String)this.description.getDisplayName()), descriptionComponent});
        grid.add(new Component[]{LabelFactory.text((String)this.amount.getDisplayName()), amountComponent, LabelFactory.text((String)this.url.getDisplayName()), urlComponent});
        group.add(customerSelector.getFocusGroup());
        group.add(locationSelector.getFocusGroup());
        group.add(processorSelector.getFocusGroup());
        group.add(descriptionComponent);
        group.add(amountComponent);
        group.add(urlComponent);
    }

    @Override
    protected String evaluate(Entity template, Context context) {
        FinancialAct act = (FinancialAct)this.service.create("act.paymentProcessorPayment", FinancialAct.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("customer", this.customer.getReference());
        bean.setTarget("location", this.location.getReference());
        bean.setTarget("paymentProcessor", this.processor.getReference());
        bean.setValue("description", (Object)this.description.getString());
        bean.setValue("url", (Object)this.url.getString());
        act.setTotal(this.amount.getBigDecimal(BigDecimal.ZERO));
        return this.evaluator.evaluate(template, act);
    }
}

