/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.AbstractDocumentTemplateQuery;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.IMObjectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.ResultSetCRUDWorkspace;
import org.openvpms.web.workspace.admin.template.AdminDocumentTemplateTableModel;
import org.openvpms.web.workspace.admin.template.AdminEmailDocumentTemplateTableModel;
import org.openvpms.web.workspace.admin.template.DocumentTemplateCRUDWindow;

public class DocumentTemplateWorkspace
extends ResultSetCRUDWorkspace<Entity> {
    public DocumentTemplateWorkspace(Context context) {
        super("admin.documentTemplate", context);
        this.setArchetypes(Entity.class, new String[]{"entity.documentTemplate", "entity.documentTemplateEmail*", "entity.documentTemplateSMS*", "entity.letterhead"});
    }

    protected Browser<Entity> createBrowser(Query<Entity> query) {
        return new TemplateBrowser(query, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }

    protected Query<Entity> createQuery() {
        return new TemplateQuery(this.getArchetypes().getShortNames());
    }

    protected CRUDWindow<Entity> createCRUDWindow() {
        QueryBrowser browser = this.getBrowser();
        return new DocumentTemplateCRUDWindow((Archetypes<Entity>)this.getArchetypes(), (Query<Entity>)browser.getQuery(), (ResultSet<Entity>)browser.getResultSet(), this.getContext(), this.getHelpContext());
    }

    private static class TemplateBrowser
    extends IMObjectTableBrowser<Entity> {
        public TemplateBrowser(Query<Entity> query, LayoutContext context) {
            super(query, context);
        }

        protected IMObjectTableModel<Entity> createTableModel(String[] archetypes, Query<Entity> query, LayoutContext context) {
            if (archetypes.length == 1) {
                String archetype = archetypes[0];
                if ("entity.documentTemplate".equals(archetype)) {
                    return new AdminDocumentTemplateTableModel(query, context);
                }
                if ("entity.documentTemplateEmailUser".equals(archetype) || "entity.documentTemplateEmailSystem".equals(archetype)) {
                    return new AdminEmailDocumentTemplateTableModel(query, context);
                }
            }
            return super.createTableModel(archetypes, query, context);
        }
    }

    private static class TemplateQuery
    extends AbstractDocumentTemplateQuery {
        public TemplateQuery(String[] shortNames) {
            super(shortNames);
            this.setContains(true);
        }
    }
}

