/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditResultSetDialog;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.workspace.DocumentActActions;
import org.openvpms.web.echo.help.HelpContext;

public class DocumentTemplateEditDialog
extends EditResultSetDialog<Entity> {
    private static final DocumentActActions actions = new DocumentActActions();

    public DocumentTemplateEditDialog(String title, Entity first, ResultSet<Entity> set, IMObjectActions<Entity> actions, Context context, HelpContext help) {
        super(title, (IMObject)first, set, actions, context, help);
        this.addButton("button.externaledit", this::onExternalEdit);
        this.enableButtons();
    }

    protected void enableButtons() {
        super.enableButtons();
        boolean enabled = actions.canExternalEdit(this.getObject());
        this.getButtons().setEnabled("button.externaledit", enabled);
    }

    private Entity getObject() {
        IMObjectEditor editor = this.getEditor();
        return editor != null ? (Entity)editor.getObject() : null;
    }

    private void onExternalEdit() {
        Entity object = this.getObject();
        if (object != null) {
            actions.externalEdit(object);
        }
    }
}

