/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.DefaultIMObjectTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.print.BoundPrinterField;
import org.openvpms.web.component.print.PrintHelper;
import org.openvpms.web.component.print.PrinterListModel;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.PrinterUseManager;
import org.springframework.transaction.PlatformTransactionManager;

public class ChangePrinterDialog
extends MessageDialog {
    private final PrinterUseManager manager;
    private final List<PrinterReference> available;
    private final Property printer;
    private final BoundPrinterField printerField;
    private final Property to;
    private final BoundPrinterField toPrinter;
    private final RadioButton change;
    private final RadioButton remove;
    private final PagedIMTable<org.openvpms.component.business.domain.im.common.Entity> table;
    private Column container;

    private ChangePrinterDialog(PrinterUseManager manager, List<PrinterReference> available, HelpContext help) {
        super(Messages.get((String)"admin.changeprinter.title"), Messages.get((String)"admin.changeprinter.message"), OK_CANCEL, help);
        this.manager = manager;
        this.available = available;
        ButtonGroup group = new ButtonGroup();
        this.printer = new SimpleProperty("printer", null, String.class, Messages.get((String)"admin.changeprinter.select"));
        this.printerField = new BoundPrinterField(this.printer, manager.getPrinters());
        this.printerField.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ChangePrinterDialog.this.onFromChanged();
            }
        });
        this.change = ButtonFactory.create((String)"admin.changeprinter.change", (ButtonGroup)group, this::onChangeSelected);
        this.remove = ButtonFactory.create((String)"admin.changeprinter.remove", (ButtonGroup)group, this::onRemoveSelected);
        this.to = new SimpleProperty("to", null, String.class);
        this.toPrinter = new BoundPrinterField(this.to, available);
        this.toPrinter.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ChangePrinterDialog.this.onToPrinterSelected();
            }
        });
        this.table = new PagedIMTable((IMTableModel)new DefaultIMObjectTableModel(true, true, false));
        this.change.setSelected(true);
        this.updateOK();
        this.resize("ChangePrinterDialog.size");
    }

    public static void show(HelpContext help) {
        List available = PrintHelper.getPrinters();
        PrinterUseManager manager = new PrinterUseManager((ArchetypeService)ServiceHelper.getArchetypeService(), (PracticeService)ServiceHelper.getBean(PracticeService.class), (LocationRules)ServiceHelper.getBean(LocationRules.class), (PlatformTransactionManager)ServiceHelper.getBean(PlatformTransactionManager.class));
        manager.refresh();
        if (manager.hasPrinters()) {
            ChangePrinterDialog dialog = new ChangePrinterDialog(manager, available, help.subtopic("changeprinter"));
            dialog.show();
        } else {
            InformationDialog.show((String)Messages.get((String)"admin.changeprinter.title"), (String)Messages.get((String)"admin.changeprinter.noupdaterequired"));
        }
    }

    protected void doLayout() {
        Label message = LabelFactory.create((boolean)true, (boolean)true);
        message.setText(this.getMessage());
        ComponentGrid grid = new ComponentGrid();
        grid.add(new Component[]{LabelFactory.text((String)this.printer.getDisplayName()), this.printerField});
        grid.add(new Component[]{this.change, this.toPrinter});
        grid.add(new Component[]{this.remove});
        this.container = ColumnFactory.create((String)"CellSpacing");
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, grid.createGrid(), this.container});
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
    }

    protected void onOK() {
        final PrinterReference from = (PrinterReference)this.printerField.getSelectedItem();
        final PrinterReference to = (PrinterReference)this.toPrinter.getSelectedItem();
        final String title = Messages.get((String)"admin.changeprinter.title");
        if (this.change.isSelected() && from != null && to != null) {
            ConfirmationDialog.show((String)title, (String)Messages.format((String)"admin.changeprinter.confirmchange", (Object[])new Object[]{from.getName(), to.getName()}), (String[])YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    try {
                        ChangePrinterDialog.this.manager.replace(from, to);
                    }
                    catch (Exception exception) {
                        ErrorHelper.show((String)title, (Throwable)exception);
                        ChangePrinterDialog.this.manager.refresh();
                    }
                    ChangePrinterDialog.super.onOK();
                }

                public void onNo() {
                    ChangePrinterDialog.this.onCancel();
                }
            });
        } else if (this.remove.isSelected() && from != null) {
            ConfirmationDialog.show((String)title, (String)Messages.format((String)"admin.changeprinter.confirmremove", (Object[])new Object[]{from.getName()}), (String[])YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    try {
                        ChangePrinterDialog.this.manager.remove(from);
                    }
                    catch (Exception exception) {
                        ErrorHelper.show((String)title, (Throwable)exception);
                        ChangePrinterDialog.this.manager.refresh();
                    }
                    ChangePrinterDialog.super.onOK();
                }

                public void onNo() {
                    ChangePrinterDialog.this.onCancel();
                }
            });
        }
    }

    private void onFromChanged() {
        ArrayList<PrinterReference> list = new ArrayList<PrinterReference>(this.available);
        PrinterReference selected = (PrinterReference)this.printerField.getSelectedItem();
        if (selected != null) {
            list.remove(selected);
            List<Entity> use = this.manager.getUse(selected);
            use.sort((o1, o2) -> {
                int result = StringUtils.compare((String)o1.getArchetype(), (String)o2.getArchetype());
                if (result == 0) {
                    result = StringUtils.compare((String)o1.getName(), (String)o2.getName());
                }
                return result;
            });
            this.table.setResultSet((ResultSet)new ListResultSet(use, 5));
            Component component = this.table.getComponent();
            if (component.getParent() == null) {
                this.container.add((Component)LabelFactory.create((String)"admin.changeprinter.usedby"));
                this.container.add(component);
            }
        } else {
            this.container.removeAll();
        }
        this.toPrinter.setModel((ListModel)new PrinterListModel(list));
        this.updateOK();
    }

    private void onChangeSelected() {
        this.toPrinter.setEnabled(true);
        this.updateOK();
    }

    private void onRemoveSelected() {
        this.toPrinter.setEnabled(false);
        this.updateOK();
    }

    private void onToPrinterSelected() {
        this.updateOK();
    }

    private void updateOK() {
        boolean enabled = this.remove.isSelected() || this.change.isSelected() && this.printerField.getSelectedItem() != null && this.toPrinter.getSelectedItem() != null;
        this.getButtons().setEnabled("ok", enabled);
    }
}

