/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;

class InnoDBStatusViewer
extends AbstractDiagnosticTab {
    private String snapshot;

    InnoDBStatusViewer() {
        super("admin.system.diagnostic.innodb");
    }

    @Override
    public Document getDocument() {
        String data;
        Document result = null;
        try {
            data = this.getData(false);
        }
        catch (Throwable exception) {
            data = this.formatError(exception);
        }
        if (data != null) {
            result = this.toText("innodb.txt", data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        Label result;
        try {
            String data = this.getData(true);
            result = data != null ? LabelFactory.preformatted((String)data) : LabelFactory.create();
        }
        catch (Throwable exception) {
            result = LabelFactory.text((String)this.formatError(exception));
        }
        return result;
    }

    private String getData(boolean refresh) throws SQLException {
        if (this.snapshot == null || refresh) {
            this.snapshot = null;
            DataSource dataSource = (DataSource)ServiceHelper.getBean(DataSource.class);
            try (Connection connection = dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                ResultSet rs = statement.executeQuery("SHOW ENGINE INNODB STATUS");
                if (rs.next()) {
                    this.snapshot = rs.getString("status");
                }
            }
        }
        return this.snapshot;
    }

    private String formatError(Throwable exception) {
        return Messages.format((String)"admin.system.diagnostic.innodb.error", (Object[])new Object[]{ErrorFormatter.format((Throwable)exception)});
    }
}

