/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.echo.table.KeyTable;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;

class DatabaseProcessViewer
extends AbstractDiagnosticTab {
    private final String[] columns = new String[]{"Host", "Id", "User", "Database", "Command", "State", "Info"};
    private List<String[]> snapshot;

    DatabaseProcessViewer() {
        super("admin.system.diagnostic.dbprocess");
    }

    @Override
    public Document getDocument() {
        Document result = null;
        List<String[]> data = this.getData(false);
        if (data != null) {
            result = this.toCSV("database.csv", this.columns, data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        KeyTable result = null;
        List<String[]> data = this.getData(true);
        if (data != null) {
            Object[][] ts = (String[][])data.toArray((T[])new String[0][0]);
            DefaultTableModel model = new DefaultTableModel(ts, (Object[])this.columns);
            KeyTable table = TableFactory.create((TableModel)model);
            table.setDefaultHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
            table.setHeaderFixed(true);
            result = table;
        }
        return result;
    }

    private List<String[]> getData(boolean refresh) {
        if (this.snapshot == null || refresh) {
            DataSource dataSource = (DataSource)ServiceHelper.getBean(DataSource.class);
            try (Connection connection = dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                ResultSet rs = statement.executeQuery("SHOW FULL PROCESSLIST");
                this.snapshot = new ArrayList<String[]>();
                while (rs.next()) {
                    this.snapshot.add(new String[]{rs.getString("host"), rs.getString("id"), rs.getString("user"), rs.getString("db"), rs.getString("command"), rs.getString("state"), rs.getString("info")});
                }
            }
            catch (Throwable exception) {
                this.snapshot = null;
                ErrorHelper.show((Throwable)exception);
            }
        }
        return this.snapshot;
    }
}

