/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.cache;

import java.util.function.Function;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.collections.Transformer;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.echo.table.CellFormat;
import org.openvpms.web.echo.table.EvenOddTableCellRenderer;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.admin.system.cache.CacheState;

class CacheTableModel
extends AbstractIMTableModel<CacheState> {
    private static final int NAME_INDEX = 0;
    private static final int COUNT_INDEX = 1;
    private static final int MAX_COUNT_INDEX = 2;
    private static final int USE_INDEX = 3;
    private static final int HITS_INDEX = 4;
    private static final int MISSES_INDEX = 5;
    private static final int SIZE_INDEX = 6;

    public CacheTableModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        Function number = CellFormat.number();
        EvenOddTableCellRenderer numericRenderer = new EvenOddTableCellRenderer(number);
        EvenOddTableCellRenderer percentRenderer = new EvenOddTableCellRenderer(CellFormat.percent());
        model.addColumn(CacheTableModel.createTableColumn((int)0, (String)"table.imobject.name"));
        model.addColumn(CacheTableModel.createTableColumn((int)1, (String)"admin.system.cache.count", (TableCellRenderer)numericRenderer));
        model.addColumn(CacheTableModel.createTableColumn((int)2, (String)"admin.system.cache.maxcount", (TableCellRenderer)numericRenderer));
        model.addColumn(CacheTableModel.createTableColumn((int)3, (String)"admin.system.cache.use", (TableCellRenderer)percentRenderer));
        model.addColumn(CacheTableModel.createTableColumn((int)4, (String)"admin.system.cache.hits", (TableCellRenderer)numericRenderer));
        model.addColumn(CacheTableModel.createTableColumn((int)5, (String)"admin.system.cache.misses", (TableCellRenderer)numericRenderer));
        model.addColumn(CacheTableModel.createTableColumn((int)6, (String)"admin.system.cache.size", (TableCellRenderer)new EvenOddTableCellRenderer(o -> {
            if (o instanceof String) {
                return TableHelper.centreAlign((String)o.toString());
            }
            return number.apply(o);
        })));
        this.setTableColumnModel((TableColumnModel)model);
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        if (column == 0) {
            return this.createSortConstraint("name", ascending, input -> ((CacheState)input).getDisplayName());
        }
        if (column == 1) {
            return this.createSortConstraint("count", ascending, input -> ((CacheState)input).getCount());
        }
        if (column == 2) {
            return this.createSortConstraint("maxcount", ascending, input -> ((CacheState)input).getMaxCount());
        }
        if (column == 3) {
            return this.createSortConstraint("use", ascending, input -> ((CacheState)input).getUse());
        }
        if (column == 4) {
            return this.createSortConstraint("hits", ascending, input -> ((CacheState)input).getHits());
        }
        if (column == 5) {
            return this.createSortConstraint("misses", ascending, input -> ((CacheState)input).getMisses());
        }
        if (column == 6) {
            return this.createSortConstraint("size", ascending, input -> ((CacheState)input).getSize());
        }
        return null;
    }

    protected Object getValue(CacheState object, TableColumn column, int row) {
        Object result = null;
        switch (column.getModelIndex()) {
            case 0: {
                result = object.getDisplayName();
                break;
            }
            case 1: {
                result = object.getCount();
                break;
            }
            case 2: {
                result = object.getMaxCount();
                break;
            }
            case 3: {
                result = object.getUse();
                break;
            }
            case 4: {
                result = object.getHits();
                break;
            }
            case 5: {
                result = object.getMisses();
                break;
            }
            case 6: {
                long size = object.getSize();
                result = size != -1L ? NumberFormatter.getSize((long)size) : "-";
            }
        }
        return result;
    }

    private SortConstraint[] createSortConstraint(String name, boolean ascending, Transformer transformer) {
        return new SortConstraint[]{new VirtualNodeSortConstraint(name, ascending, transformer)};
    }
}

