/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.cache;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.event.ActionListener;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.workspace.admin.system.cache.CacheState;
import org.openvpms.web.workspace.admin.system.cache.CacheTableModel;
import org.openvpms.web.workspace.admin.system.cache.Caches;
import org.openvpms.web.workspace.admin.system.cache.Memory;

public class CacheBrowser {
    private final Memory memory = new Memory();
    private final Caches caches = new Caches();
    private final PagedIMTable<CacheState> table = new PagedIMTable((IMTableModel)new CacheTableModel());

    public CacheBrowser() {
        ListResultSet<CacheState> set = new ListResultSet<CacheState>(this.caches.getCaches(), 20){

            public void sort(SortConstraint[] sort) {
                super.sort(sort);
                IMObjectSorter.sort((List)this.getObjects(), (SortConstraint[])sort, input -> input);
            }
        };
        this.table.setResultSet((ResultSet)set);
    }

    public CacheState getSelected() {
        return (CacheState)this.table.getSelected();
    }

    public void addActionListener(ActionListener listener) {
        this.table.getTable().addActionListener(listener);
    }

    public Component getComponent() {
        Button calc = ButtonFactory.create((String)"button.calculatesize", this::calculateSizes);
        calc.setLayoutData((LayoutData)RowFactory.layout((Alignment)Alignment.ALIGN_TOP));
        return ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.memory.getComponent(), RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.table.getComponent(), calc})});
    }

    public FocusGroup getFocusGroup() {
        return this.table.getFocusGroup();
    }

    public void refresh() {
        for (CacheState cache : this.caches.getCaches()) {
            cache.refreshStatistics();
        }
        this.updateTable();
        this.memory.refresh();
    }

    public void resetStatistics() {
        for (CacheState cache : this.caches.getCaches()) {
            cache.resetStatistics();
        }
        this.refresh();
    }

    public void clear() {
        CacheState cache = (CacheState)this.table.getSelected();
        if (cache != null) {
            cache.clear();
            cache.resetStatistics();
            cache.refreshStatistics();
            this.updateTable();
        }
    }

    public long getSuggestedSize(CacheState cache) {
        return this.caches.getSuggestedSize(cache);
    }

    private void calculateSizes() {
        for (CacheState cache : this.caches.getCaches()) {
            cache.refreshCacheSize();
        }
        this.updateTable();
        this.memory.refresh();
    }

    private void updateTable() {
        ResultSet set = this.table.getResultSet();
        set.sort(set.getSortConstraints());
        this.table.getModel().refresh();
    }
}

