/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system;

import io.milton.http.LockTimeout;
import io.milton.http.LockToken;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.query.FilteredResultSet;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.webdav.resource.ResourceLock;
import org.openvpms.web.webdav.resource.ResourceLockManager;
import org.openvpms.web.workspace.admin.system.AbstractTabComponent;

public class WebDAVLockBrowser
extends AbstractTabComponent {
    private final ResourceLockManager lockManager;
    private final SimpleProperty search = new SimpleProperty("search", null, String.class, Messages.get((String)"query.search"));
    private PagedIMTable<ResourceLock> locks;
    private TextField field;
    private Component component;
    private static final String QUERY_ID = "button.query";
    private static final String DELETE_ID = "button.delete";

    public WebDAVLockBrowser(HelpContext help) {
        super(help);
        this.lockManager = (ResourceLockManager)ServiceHelper.getBean(ResourceLockManager.class);
    }

    public void show() {
        this.refresh();
        FocusHelper.setFocus((Component)this.field);
    }

    public Component getComponent() {
        if (this.component == null) {
            FocusGroup focus = this.getFocusGroup();
            this.field = BoundTextComponentFactory.create((Property)this.search, (int)20);
            this.field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    WebDAVLockBrowser.this.refresh();
                }
            });
            focus.add((Component)this.field);
            ButtonRow query = new ButtonRow(focus);
            query.addButton(QUERY_ID, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    WebDAVLockBrowser.this.onQuery();
                }
            });
            this.locks = new PagedIMTable((IMTableModel)new LockTableModel());
            this.locks.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    WebDAVLockBrowser.this.enableButtons();
                }
            });
            ButtonSet buttons = this.getButtonSet();
            buttons.add(DELETE_ID, this::onDelete);
            buttons.setEnabled(DELETE_ID, false);
            Label label = LabelFactory.create();
            label.setText(this.search.getDisplayName());
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, this.field, query});
            Column column = ColumnFactory.create((String)"Inset", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{row, this.locks.getComponent()})});
            focus.add(this.locks.getComponent());
            focus.add(this.getButtonSet().getFocusGroup());
            this.component = SplitPaneFactory.create((int)6, (String)"SplitPaneWithButtonRow", (Component[])new Component[]{this.getButtons(), column});
        }
        return this.component;
    }

    private void onQuery() {
        this.refresh();
        if (!this.locks.getTable().getObjects().isEmpty()) {
            FocusHelper.setFocus((Component)this.locks.getTable());
        }
    }

    private void enableButtons() {
        this.getButtonSet().setEnabled(DELETE_ID, this.locks.getSelected() != null);
    }

    private void onDelete() {
        final ResourceLock selected = (ResourceLock)this.locks.getSelected();
        if (selected != null) {
            String name = UserHelper.getName((String)selected.getUser());
            String title = Messages.get((String)"admin.system.webdav.deletelock.title");
            String message = Messages.format((String)"admin.system.webdav.deletelock.message", (Object[])new Object[]{name});
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, ConfirmationDialog.YES_NO);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    WebDAVLockBrowser.this.lockManager.remove(selected);
                    WebDAVLockBrowser.this.refresh();
                    WebDAVLockBrowser.this.enableButtons();
                }
            });
            dialog.show();
        }
    }

    private void refresh() {
        this.locks.setResultSet(this.getLocks());
    }

    private ResultSet<ResourceLock> getLocks() {
        List locks = this.lockManager.getLocked();
        Object set = new ListResultSet(locks, 20);
        final String query = this.search.getString();
        if (!StringUtils.isEmpty((CharSequence)query)) {
            set = new FilteredResultSet<ResourceLock>((ResultSet)set){

                protected void filter(ResourceLock object, List<ResourceLock> results) {
                    if (this.contains(object.getUser(), query) || this.contains(object.getName(), query) || this.contains(UserHelper.getName((String)object.getUser()), query)) {
                        results.add(object);
                    }
                }

                boolean contains(String value, String search) {
                    return value != null && value.toLowerCase().contains(search.toLowerCase());
                }
            };
        }
        set.sort(new SortConstraint[]{LockTableModel.getSortOnLogin(true)});
        return set;
    }

    private static class LockTableModel
    extends AbstractIMTableModel<ResourceLock> {
        private static final int LOGIN_INDEX = 0;
        private static final int USER_INDEX = 1;
        private static final int RESOURCE_INDEX = 2;
        private static final int EXPIRY_DATE_INDEX = 3;

        public LockTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(LockTableModel.createTableColumn((int)0, (String)"admin.system.login"));
            model.addColumn(LockTableModel.createTableColumn((int)1, (String)"admin.system.user"));
            model.addColumn(LockTableModel.createTableColumn((int)2, (String)"admin.system.webdav.lock.resource"));
            model.addColumn(LockTableModel.createTableColumn((int)3, (String)"admin.system.webdav.lock.expiry"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            SortConstraint[] sortConstraintArray;
            SortConstraint sort = null;
            switch (column) {
                case 0: {
                    sort = LockTableModel.getSortOnLogin(ascending);
                    break;
                }
                case 1: {
                    sort = new VirtualNodeSortConstraint("user", ascending, input -> {
                        String login = ((ResourceLock)input).getUser();
                        return UserHelper.getName((String)login);
                    });
                    break;
                }
                case 2: {
                    sort = new VirtualNodeSortConstraint("resource", ascending, input -> ((ResourceLock)input).getName());
                }
            }
            if (sort != null) {
                SortConstraint[] sortConstraintArray2 = new SortConstraint[1];
                sortConstraintArray = sortConstraintArray2;
                sortConstraintArray2[0] = sort;
            } else {
                sortConstraintArray = null;
            }
            return sortConstraintArray;
        }

        public static SortConstraint getSortOnLogin(boolean ascending) {
            VirtualNodeSortConstraint sort = new VirtualNodeSortConstraint("login", ascending, input -> ((ResourceLock)input).getUser());
            return sort;
        }

        protected Object getValue(ResourceLock object, TableColumn column, int row) {
            String result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getUser();
                    break;
                }
                case 1: {
                    result = UserHelper.getName((String)object.getUser());
                    break;
                }
                case 2: {
                    result = object.getName();
                    break;
                }
                case 3: {
                    result = this.getExpiry(object);
                }
            }
            return result;
        }

        private String getExpiry(ResourceLock object) {
            LockToken token = object.getToken();
            Date from = token.getFrom();
            Date to = null;
            LockTimeout timeout = token.timeout;
            if (timeout.getSeconds() != null && timeout.getSeconds() != Long.MAX_VALUE) {
                to = new DateTime((Object)from).plusSeconds((int)timeout.getSeconds().longValue()).toDate();
            }
            return to != null ? DateFormatter.formatDateTimeAbbrev(to) : null;
        }
    }
}

