/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.schedule;

import java.util.Date;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;

public class ScheduleEditor
extends AbstractIMObjectEditor {
    private final AppointmentRules rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
    private int savedMaxDuration = -1;
    private DateUnits savedMaxDurationUnits;
    private boolean confirmMaxDurationReduction = true;
    private boolean showingMaxDurationConfirmationReduction = false;
    private static final DurationFormatter formatter = DateDurationFormatter.create((boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    private static final String MAX_DURATION = "maxDuration";
    private static final String MAX_DURATION_UNITS = "maxDurationUnits";

    public ScheduleEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        if (object.isNew()) {
            Party location = layoutContext.getContext().getLocation();
            if (location != null) {
                IMObjectBean bean = this.getBean((IMObject)object);
                bean.setTarget("location", (IMObject)location);
            }
        } else {
            this.updateSavedDuration();
        }
    }

    public IMObjectEditor newInstance() {
        return new ScheduleEditor((Entity)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    public void setMaxDuration(int duration, DateUnits units) {
        this.getProperty(MAX_DURATION).setValue((Object)(duration > 0 ? Integer.valueOf(duration) : null));
        this.getProperty(MAX_DURATION_UNITS).setValue((Object)(units != null ? units.toString() : null));
    }

    public int getMaxDuration() {
        return this.getProperty(MAX_DURATION).getInt(-1);
    }

    public DateUnits getMaxDurationUnits() {
        return DateUnits.fromString((String)this.getProperty(MAX_DURATION_UNITS).getString());
    }

    protected void onLayoutCompleted() {
        ModifiableListener listener = modifiable -> this.onMaxDurationChanged();
        this.getProperty(MAX_DURATION).addModifiableListener(listener);
        this.getProperty(MAX_DURATION_UNITS).addModifiableListener(listener);
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateTimes(validator) && this.validateMaxDuration(validator);
    }

    protected void doSave() {
        super.doSave();
        this.updateSavedDuration();
    }

    private boolean maxDurationReduced() {
        return this.checkDuration(this.getMaxDuration(), this.getMaxDurationUnits());
    }

    private void onMaxDurationChanged() {
        if (!this.showingMaxDurationConfirmationReduction && this.maxDurationReduced() && this.confirmMaxDurationReduction) {
            this.showingMaxDurationConfirmationReduction = true;
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"workflow.scheduling.durationreduction.title"))).message(Messages.get((String)"workflow.scheduling.durationreduction.message"))).yesNo()).yes(() -> {
                this.confirmMaxDurationReduction = false;
                this.showingMaxDurationConfirmationReduction = false;
            })).no(() -> {
                this.setMaxDuration(this.savedMaxDuration, this.savedMaxDurationUnits);
                this.confirmMaxDurationReduction = false;
                this.showingMaxDurationConfirmationReduction = false;
            })).show();
        }
    }

    private void updateSavedDuration() {
        this.savedMaxDuration = this.getMaxDuration();
        this.savedMaxDurationUnits = this.getMaxDurationUnits();
    }

    private boolean validateMaxDuration(Validator validator) {
        boolean result = false;
        if (this.getObject().isNew()) {
            result = true;
        } else if (!this.showingMaxDurationConfirmationReduction) {
            DateUnits units;
            int duration = this.getMaxDuration();
            if (this.checkDuration(duration, units = this.getMaxDurationUnits())) {
                Act event = this.rules.getAppointmentEventLongerThanDuration((Entity)this.getObject(), DateRules.getToday(), duration, units);
                if (event != null) {
                    String date = DateFormatter.formatDate((Date)event.getActivityStartTime(), (boolean)false);
                    String time = DateFormatter.formatTime((Date)event.getActivityStartTime(), (boolean)false);
                    String eventDuration = formatter.format(event.getActivityStartTime(), event.getActivityEndTime());
                    validator.add((Modifiable)this, Messages.format((String)"workflow.scheduling.eventexceedsduration", (Object[])new Object[]{eventDuration, this.getDisplayName((IMObject)event), date, time}));
                } else {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private boolean checkDuration(int duration, DateUnits units) {
        boolean result = true;
        if (duration > 0 && units != null && (duration != this.savedMaxDuration || units != this.savedMaxDurationUnits)) {
            if (this.savedMaxDuration > 0 && this.savedMaxDurationUnits != null) {
                Date today = new Date();
                Date saved = DateRules.getDate((Date)today, (int)this.savedMaxDuration, (DateUnits)this.savedMaxDurationUnits);
                Date current = DateRules.getDate((Date)today, (int)duration, (DateUnits)units);
                if (current.compareTo(saved) >= 0) {
                    result = false;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean validateTimes(Validator validator) {
        boolean valid = false;
        Date startTime = this.getProperty("startTime").getDate();
        Date endTime = this.getProperty("endTime").getDate();
        if (startTime == null && endTime != null || startTime != null && endTime == null) {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"schedule.time.bothRequired")));
        } else if (startTime != null && DateRules.compareTo((Date)startTime, (Date)endTime) >= 0) {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"schedule.time.less")));
        } else {
            valid = true;
        }
        return valid;
    }
}

