/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.printer;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.print.BoundPrinterField;
import org.openvpms.web.component.print.PrinterListModel;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.workspace.admin.organisation.printer.PrinterLayoutStrategy;

public class PrinterEditor
extends AbstractIMObjectEditor {
    private final PropertyComponentEditor printer;
    private final SelectField printerSelector;

    public PrinterEditor(IMObject object, IMObject parent, List<PrinterReference> availablePrinters, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        Property property = this.getProperty("printer");
        this.printerSelector = new BoundPrinterField(property, availablePrinters);
        this.printer = new PropertyComponentEditor(property, (Component)this.printerSelector);
        this.printer.addModifiableListener(modifiable -> this.onPrinterChanged());
        this.addEditor((Editor)this.printer);
    }

    public void setAvailablePrinters(List<PrinterReference> references) {
        ((SelectField)this.printer.getComponent()).setModel(this.createModel(references));
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        PrinterLayoutStrategy strategy = new PrinterLayoutStrategy();
        strategy.addComponent(new ComponentState((PropertyEditor)this.printer));
        return strategy;
    }

    private ListModel createModel(Collection<PrinterReference> references) {
        PrinterReference reference = PrinterReference.fromString((String)this.getProperty("printer").getString());
        if (reference != null) {
            references = new HashSet<PrinterReference>(references);
            references.add(reference);
        }
        return new PrinterListModel(references);
    }

    private void onPrinterChanged() {
        PrinterReference reference = (PrinterReference)this.printerSelector.getSelectedItem();
        String name = reference != null ? reference.getName() : null;
        this.getProperty("name").setValue((Object)name);
    }
}

