/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation.practice;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.ShortNameListCellRenderer;
import org.openvpms.web.component.im.list.ShortNameListModel;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.subscription.SubscriptionHelper;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.organisation.AbstractOrganisationLayoutStrategy;
import org.openvpms.web.workspace.admin.organisation.practice.SubscriptionViewer;

public class PracticeLayoutStrategy
extends AbstractOrganisationLayoutStrategy {
    private ComponentState subscription;
    private static final String MINIMUM_QUANTITIES_OVERRIDE = "minimumQuantitiesOverride";
    private static final ArchetypeNodes NODES = new ArchetypeNodes().exclude(new String[]{"minimumQuantitiesOverride"});

    public PracticeLayoutStrategy() {
        super(NODES);
    }

    public PracticeLayoutStrategy(Component subscription, FocusGroup focusGroup) {
        super(NODES);
        this.subscription = new ComponentState(subscription, focusGroup);
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        IMObjectComponentFactory factory = context.getComponentFactory();
        this.addDefaultPaymentType(properties, context);
        this.addMinimumQuantities(object, properties, factory);
        if (this.subscription == null) {
            Participation participation = SubscriptionHelper.getSubscriptionParticipation((Party)((Party)object), (IArchetypeService)this.getService());
            SubscriptionViewer viewer = new SubscriptionViewer(context);
            if (participation != null) {
                DocumentAct act = (DocumentAct)context.getCache().get(participation.getAct());
                viewer.setSubscription(act);
            }
            this.subscription = new ComponentState(viewer.getComponent());
        }
        return super.apply(object, properties, parent, context);
    }

    protected void doTabLayout(IMObject object, List<Property> properties, IMObjectTabPaneModel model, LayoutContext context, boolean shortcuts) {
        super.doTabLayout(object, properties, model, context, shortcuts);
        this.addTab(Messages.get((String)"admin.practice.subscription"), model, (Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.subscription.getComponent()}));
    }

    private void addDefaultPaymentType(PropertySet properties, LayoutContext context) {
        TextComponent component;
        Property property = properties.get("defaultPaymentType");
        if (context.isEdit()) {
            String[] archetypes = RelationshipHelper.getTargetShortNames((ArchetypeService)this.getService(), (String[])new String[]{"actRelationship.customerAccountPaymentItem"});
            ShortNameListModel model = new ShortNameListModel(archetypes);
            SelectField field = BoundSelectFieldFactory.create((Property)property, (ListModel)model);
            field.setCellRenderer((ListCellRenderer)new ShortNameListCellRenderer());
            component = field;
        } else {
            String value = property.getString();
            if (value != null) {
                value = this.getDisplayName(value);
            }
            component = ReadOnlyComponentFactory.getText((String)value, (int)property.getMaxLength(), (int)50, (String)"default");
        }
        this.addComponent(new ComponentState((Component)component, property));
    }

    private void addMinimumQuantities(IMObject object, PropertySet properties, IMObjectComponentFactory factory) {
        Property minimumQuantities = properties.get("minimumQuantities");
        Property minimumQuantitiesOverride = properties.get(MINIMUM_QUANTITIES_OVERRIDE);
        ComponentState quantities = factory.create(minimumQuantities, object);
        ComponentState override = factory.create(minimumQuantitiesOverride, object);
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{quantities.getComponent(), override.getLabel(), override.getComponent()});
        FocusGroup group = new FocusGroup(minimumQuantities.getName());
        group.add(quantities.getComponent());
        group.add(override.getComponent());
        this.addComponent(new ComponentState((Component)row, minimumQuantities, group));
    }
}

