/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.organisation;

import java.util.List;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.sync.DefaultChanges;
import org.openvpms.domain.sync.Changes;
import org.openvpms.eftpos.internal.service.EFTPOSServices;
import org.openvpms.eftpos.internal.terminal.TerminalImpl;
import org.openvpms.eftpos.service.EFTPOSService;
import org.openvpms.eftpos.service.ManagedTerminalRegistrar;
import org.openvpms.eftpos.service.TerminalRegistrar;
import org.openvpms.eftpos.service.WebTerminalRegistrar;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.terminal.TerminalStatus;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.eftpos.ManagedTerminalRegistrationDialog;
import org.openvpms.web.workspace.admin.eftpos.WebTerminalRegistrationDialog;
import org.openvpms.web.workspace.admin.organisation.InsurerChanges;

public class OrganisationCRUDWindow
extends ResultSetCRUDWindow<Entity> {
    private static final String REGISTER_ID = "button.register";
    private static final String SYNC_DATA = "button.sync";

    public OrganisationCRUDWindow(Archetypes<Entity> archetypes, Query<Entity> query, ResultSet<Entity> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(REGISTER_ID, this::onRegister);
        buttons.add(SYNC_DATA, this::synchroniseData);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(REGISTER_ID, enable && TypeHelper.isA((IMObject)this.getObject(), (String)"entity.EFTPOSTerminal*"));
        buttons.setEnabled(SYNC_DATA, enable && TypeHelper.isA((IMObject)this.getObject(), (String)"entity.insuranceService*"));
    }

    protected void synchroniseData() {
        Entity object = (Entity)this.getObject();
        if (TypeHelper.isA((IMObject)object, (String)"entity.insuranceService*")) {
            this.synchroniseInsurers(object);
        }
    }

    protected void synchroniseInsurers(Entity object) {
        InsuranceServices insuranceServices = (InsuranceServices)ServiceHelper.getBean(InsuranceServices.class);
        InsuranceService service = insuranceServices.getServiceForConfiguration(object);
        DefaultChanges changes = new DefaultChanges();
        service.synchroniseInsurers((Changes)changes);
        List list = changes.getChanges();
        if (list.isEmpty()) {
            InformationDialog.show((String)Messages.get((String)"admin.organisation.insurer.sync.title"), (String)Messages.format((String)"admin.organisation.insurer.sync.nochanges", (Object[])new Object[]{object.getName()}));
        } else {
            InsurerChanges popup = new InsurerChanges(list);
            popup.show();
        }
    }

    private void onRegister() {
        Entity config = (Entity)IMObjectHelper.reload((IMObject)this.getObject());
        if (config != null) {
            String title = Messages.get((String)"admin.eftpos.register.title");
            try {
                TerminalImpl terminal = new TerminalImpl(config, (ArchetypeService)ServiceHelper.getArchetypeService());
                EFTPOSServices eftposServices = (EFTPOSServices)ServiceHelper.getBean(EFTPOSServices.class);
                final EFTPOSService service = eftposServices.getService((Entity)terminal);
                TerminalStatus status = service.getTerminalStatus((Terminal)terminal);
                if (status.isError()) {
                    ErrorDialog.show((String)title, (String)status.getMessage());
                } else if (status.isRegistrationRequired()) {
                    if (status.canRegister()) {
                        this.register(service, (Terminal)terminal, title, config);
                    } else {
                        InformationDialog.show((String)title, (String)Messages.get((String)"admin.eftpos.register.registerexternal"));
                    }
                } else if (status.canRegister()) {
                    if (status.isRegistered()) {
                        ConfirmationDialog.show((String)title, (String)Messages.get((String)"admin.eftpos.register.reregister"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener((Terminal)terminal, title, config){
                            final /* synthetic */ Terminal val$terminal;
                            final /* synthetic */ String val$title;
                            final /* synthetic */ Entity val$config;
                            {
                                this.val$terminal = terminal;
                                this.val$title = string;
                                this.val$config = entity;
                            }

                            public void onYes() {
                                OrganisationCRUDWindow.this.register(service, this.val$terminal, this.val$title, this.val$config);
                            }
                        });
                    } else {
                        this.register(service, (Terminal)terminal, title, config);
                    }
                } else if (status.isRegistered()) {
                    InformationDialog.show((String)title, (String)Messages.get((String)"admin.eftpos.register.alreadyregistered"));
                } else {
                    InformationDialog.show((String)title, (String)Messages.get((String)"admin.eftpos.register.registerexternal"));
                }
            }
            catch (Exception exception) {
                ErrorHelper.show((String)title, (Throwable)exception);
            }
        }
    }

    private void register(EFTPOSService service, Terminal terminal, String title, final Entity config) {
        try {
            TerminalRegistrar registration = service.register(terminal);
            if (registration instanceof WebTerminalRegistrar) {
                WebTerminalRegistrationDialog dialog = new WebTerminalRegistrationDialog(terminal, (WebTerminalRegistrar)registration);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onClose(WindowPaneEvent event) {
                        OrganisationCRUDWindow.this.onRefresh((IMObject)config);
                    }
                });
                dialog.show();
            } else if (registration instanceof ManagedTerminalRegistrar) {
                ManagedTerminalRegistrationDialog dialog = new ManagedTerminalRegistrationDialog((ManagedTerminalRegistrar)registration, this.getHelpContext());
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onClose(WindowPaneEvent event) {
                        OrganisationCRUDWindow.this.onRefresh((IMObject)config);
                    }
                });
                dialog.show();
            } else {
                this.onRefresh((IMObject)config);
            }
        }
        catch (Exception exception) {
            ErrorHelper.show((String)title, (Throwable)exception);
        }
    }
}

