/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.mapping;

import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.mapping.model.Mapping;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Source;
import org.openvpms.mapping.model.Target;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.mapping.MappingSource;
import org.openvpms.web.workspace.admin.mapping.MappingState;
import org.openvpms.web.workspace.admin.mapping.SourceImpl;
import org.openvpms.web.workspace.admin.mapping.TargetEditor;

class MappingEditor<T extends IMObject>
extends Editors {
    private final MappingState mapping;
    private final Mappings<T> mappings;
    private final MappingSource source;
    private final TargetEditor target;

    MappingEditor(MappingState mapping, Mappings<T> mappings, LayoutContext context) {
        this.mapping = mapping;
        this.mappings = mappings;
        this.source = new ReadOnlySource(mapping);
        this.target = new TargetEditor(mapping.getTarget(), mappings, context);
        this.add((Editor)this.target);
    }

    public MappingSource getSource() {
        return this.source;
    }

    public TargetEditor getTarget() {
        return this.target;
    }

    protected void onModified(Modifiable modified) {
        Source newSource = this.source.getObject();
        Target newTarget = this.target.getObject();
        if (newSource != null && newTarget != null) {
            if (!Objects.equals(newSource.getId(), this.mapping.getSource()) || !Objects.equals(newTarget, this.mapping.getTarget())) {
                Class type = this.mappings.getType();
                IMObject object = IMObjectHelper.getObject((Reference)newSource.getId(), (Class)type);
                if (this.mapping.getMapping() == null) {
                    Mapping newMapping = this.mappings.add(object, newTarget);
                    this.mapping.setMapping(newMapping);
                } else {
                    this.mappings.replace(this.mapping.getMapping(), object, newTarget);
                }
            }
        } else if (this.mapping.getMapping() != null) {
            Mapping existing = this.mapping.getMapping();
            this.mappings.remove(existing);
            this.mapping.setMapping(null);
        }
        super.onModified(modified);
    }

    private static class ReadOnlySource
    implements MappingSource {
        private final Label label;
        private final Source source;

        ReadOnlySource(MappingState state) {
            String name = IMObjectHelper.getName((Reference)state.getSource());
            if (name == null) {
                name = Messages.get((String)"imobject.none");
            }
            this.label = LabelFactory.text((String)name);
            this.source = new SourceImpl(state.getSource(), name);
        }

        @Override
        public Source getObject() {
            return this.source;
        }

        @Override
        public Component getComponent() {
            return this.label;
        }
    }
}

