/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.lookup.AbstractLookupEditor;
import org.openvpms.web.workspace.admin.lookup.OAuth2ClientRegistrationLayoutStrategy;

public class OAuth2ClientRegistrationEditor
extends AbstractLookupEditor {
    public static final String GMAIL = "gmail";
    public static final String OUTLOOK = "outlook";
    private ComponentState codeComponent;
    private boolean tenantIdDisplayed;
    private static final String TENANT_ID = "tenantId";

    public OAuth2ClientRegistrationEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateTenantId(validator) && this.validateSecret(validator);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        if (this.codeComponent == null) {
            Property code = this.getProperty("code");
            this.codeComponent = this.getLayoutContext().getComponentFactory().create(code, this.getObject());
            code.addModifiableListener(modifiable -> this.onCodeChanged());
        }
        OAuth2ClientRegistrationLayoutStrategy layoutStrategy = new OAuth2ClientRegistrationLayoutStrategy();
        layoutStrategy.addComponent(this.codeComponent);
        return layoutStrategy;
    }

    protected void onLayoutCompleted() {
        this.tenantIdDisplayed = this.displayTenantId();
        if (this.tenantIdDisplayed && StringUtils.trimToNull((String)this.getProperty(TENANT_ID).getString()) == null) {
            this.getFocusGroup().setDefault(this.getEditor(TENANT_ID).getComponent());
        }
    }

    private boolean validateTenantId(Validator validator) {
        boolean valid = true;
        Property tenantId = this.getProperty(TENANT_ID);
        if (StringUtils.trimToNull((String)tenantId.getString()) == null && OUTLOOK.equals(this.getCode())) {
            valid = false;
            validator.add((Modifiable)this, new ValidatorError(tenantId, Messages.format((String)"property.error.required", (Object[])new Object[]{tenantId.getDisplayName()})));
        }
        return valid;
    }

    private boolean validateSecret(Validator validator) {
        boolean valid = true;
        String code = this.getCode();
        Property secret = this.getProperty("clientSecret");
        if (StringUtils.trimToNull((String)secret.getString()) == null && (GMAIL.equals(code) || OUTLOOK.equals(code))) {
            valid = false;
            validator.add((Modifiable)this, new ValidatorError(secret, Messages.format((String)"property.error.required", (Object[])new Object[]{secret.getDisplayName()})));
        }
        return valid;
    }

    private boolean displayTenantId() {
        return OUTLOOK.equals(this.getCode());
    }

    private void onCodeChanged() {
        if (this.tenantIdDisplayed != this.displayTenantId()) {
            this.onLayout();
        } else {
            OAuth2ClientRegistrationLayoutStrategy layout = (OAuth2ClientRegistrationLayoutStrategy)this.getView().getLayout();
            if (layout != null) {
                layout.updateRedirectURI((Lookup)this.getObject());
            }
        }
    }
}

