/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.laboratory.io;

import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.laboratory.internal.io.LaboratoryTestData;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.TableColumnFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

class LaboratoryTestDataModel
extends AbstractIMTableModel<LaboratoryTestData> {
    private static final int ID = 0;
    private static final int LABORATORY = 1;
    private static final int CODE = 2;
    private static final int NAME = 3;
    private static final int DESCRIPTION = 4;
    private static final int OLD_PRICE = 5;
    private static final int NEW_PRICE = 6;
    private static final int SPECIMEN = 7;
    private static final int TURNAROUND = 8;

    public LaboratoryTestDataModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(TableColumnFactory.create((int)0, (Object)this.getDisplayName("entity.laboratoryTest", "id")));
        model.addColumn(TableColumnFactory.create((int)1, (Object)this.getDisplayName("entity.investigationType", "laboratory")));
        model.addColumn(TableColumnFactory.create((int)2, (Object)this.getDisplayName("entity.laboratoryTest", "code")));
        model.addColumn(TableColumnFactory.create((int)3, (Object)this.getDisplayName("entity.laboratoryTest", "name")));
        model.addColumn(TableColumnFactory.create((int)4, (Object)this.getDisplayName("entity.laboratoryTest", "description")));
        model.addColumn(LaboratoryTestDataModel.createTableColumn((int)5, (String)"admin.laboratory.import.oldPrice"));
        model.addColumn(LaboratoryTestDataModel.createTableColumn((int)6, (String)"admin.laboratory.import.newPrice"));
        model.addColumn(TableColumnFactory.create((int)7, (Object)this.getDisplayName("entity.laboratoryTest", "specimen")));
        model.addColumn(TableColumnFactory.create((int)8, (Object)this.getDisplayName("entity.laboratoryTest", "turnaround")));
        this.setTableColumnModel((TableColumnModel)model);
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    protected Object getValue(LaboratoryTestData object, TableColumn column, int row) {
        Object result;
        switch (column.getModelIndex()) {
            case 0: {
                result = this.getId(object);
                break;
            }
            case 1: {
                result = object.getLaboratory();
                break;
            }
            case 2: {
                result = object.getCode();
                break;
            }
            case 3: {
                result = object.getName();
                break;
            }
            case 4: {
                result = object.getDescription();
                break;
            }
            case 5: {
                result = TableHelper.rightAlign((String)NumberFormatter.formatCurrency((Number)object.getOldPrice()));
                break;
            }
            case 6: {
                result = TableHelper.rightAlign((String)NumberFormatter.formatCurrency((Number)object.getNewPrice()));
                break;
            }
            case 7: {
                result = object.getSpecimen();
                break;
            }
            case 8: {
                result = object.getTurnaround();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private Object getId(LaboratoryTestData object) {
        Label result = object.getTest() == null || object.getTest().isNew() ? LabelFactory.text((String)Messages.format((String)"editor.new.title", (Object[])new Object[]{this.getDisplayName("entity.laboratoryTest")}), (String)"italic") : TableHelper.rightAlign((String)Long.toString(object.getTest().getId()));
        return result;
    }
}

