/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.laboratory;

import java.util.List;
import nextapp.echo2.app.filetransfer.UploadListener;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.internal.sync.DefaultChanges;
import org.openvpms.domain.sync.Changes;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataReader;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataSet;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.laboratory.io.LaboratoryTestImportDialog;
import org.openvpms.web.workspace.admin.laboratory.io.LaboratoryTestImportErrorDialog;
import org.openvpms.web.workspace.admin.sync.SynchronisationChanges;

public class LaboratoryCRUDWindow
extends ResultSetCRUDWindow<Entity> {
    private static final String SYNC_DATA = "button.sync";
    private static final String IMPORT = "button.import";

    public LaboratoryCRUDWindow(Archetypes<Entity> archetypes, Query<Entity> query, ResultSet<Entity> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(SYNC_DATA, this::synchroniseData);
        buttons.add(IMPORT, this::onImport);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(SYNC_DATA, enable && TypeHelper.isA((IMObject)this.getObject(), (String)"entity.laboratoryService*"));
    }

    private void synchroniseData() {
        Entity object = (Entity)this.getObject();
        if (TypeHelper.isA((IMObject)object, (String)"entity.laboratoryService*")) {
            LaboratoryServices services = (LaboratoryServices)ServiceHelper.getBean(LaboratoryServices.class);
            LaboratoryService service = services.getService(object);
            DefaultChanges changes = new DefaultChanges();
            service.synchroniseData((Changes)changes);
            List list = changes.getChanges();
            if (list.isEmpty()) {
                InformationDialog.show((String)Messages.get((String)"admin.laboratory.sync.title"), (String)Messages.format((String)"admin.laboratory.sync.noChanges", (Object[])new Object[]{object.getName()}));
            } else {
                SynchronisationChanges popup = new SynchronisationChanges(Messages.get((String)"admin.laboratory.sync.title"), list);
                popup.show();
            }
        }
    }

    private void onImport() {
        final HelpContext help = this.getHelpContext().subtopic("import");
        DocumentUploadListener listener = new DocumentUploadListener(){

            protected void upload(Document document) {
                try {
                    LaboratoryCRUDWindow.this.importDocument(document, help);
                }
                catch (Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
            }
        };
        UploadDialog dialog = new UploadDialog((UploadListener)listener, help.subtopic("upload"));
        dialog.show();
    }

    private void importDocument(Document document, HelpContext help) {
        LaboratoryTestDataReader reader = (LaboratoryTestDataReader)ServiceHelper.getBean(LaboratoryTestDataReader.class);
        LaboratoryTestDataSet data = reader.read(document);
        if (data.getErrors().isEmpty()) {
            if (!data.getData().isEmpty()) {
                LaboratoryTestImportDialog dialog = new LaboratoryTestImportDialog(data, this.getContext(), help);
                dialog.show();
            } else {
                InformationDialog.show((String)Messages.get((String)"admin.laboratory.import.title"), (String)Messages.get((String)"admin.laboratory.import.noChanges"));
            }
        } else {
            List errors = data.getErrors();
            LaboratoryTestImportErrorDialog dialog = new LaboratoryTestImportErrorDialog(errors, help);
            dialog.show();
        }
    }
}

