/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectTabPane;
import org.openvpms.web.component.im.layout.IMObjectTabPaneModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.job.scheduledreport.ParameterComponents;
import org.openvpms.web.workspace.admin.job.scheduledreport.Parameters;

public class ScheduledReportJobConfigurationLayoutStrategy
extends AbstractLayoutStrategy {
    private ParameterComponents parameters;
    private Component parameterList;

    public ScheduledReportJobConfigurationLayoutStrategy() {
        this(null);
    }

    protected ScheduledReportJobConfigurationLayoutStrategy(ParameterComponents parameters) {
        this.parameters = parameters;
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ArchetypeNodes nodes = ArchetypeNodes.all();
        this.parameterList = this.createParameters(properties, nodes, context);
        StringBuilder builder = new StringBuilder();
        List<Property> emails = this.getEmailTo(properties);
        for (int i = 1; i < emails.size(); ++i) {
            nodes.exclude(new String[]{emails.get(i).getName()});
        }
        if (!context.isEdit()) {
            for (Property property : emails) {
                String address = property.getString();
                if (StringUtils.isEmpty((CharSequence)address)) continue;
                if (builder.length() != 0) {
                    builder.append("; ");
                }
                builder.append(address);
            }
            Property first = emails.get(0);
            SimpleProperty emailTo = new SimpleProperty(first.getName(), (Object)builder.toString(), String.class, first.getDisplayName());
            this.addComponent(this.createComponent((Property)emailTo, object, context));
        }
        this.setArchetypeNodes(nodes);
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        ArrayList<Property> list = new ArrayList<Property>(properties);
        ComponentGrid grid = new ComponentGrid();
        List main = ArchetypeNodes.removeAll(list, (String[])new String[]{"id", "report", "name", "description", "active", "location", "reportName", "reportNameFormat"});
        grid.add(this.createComponentSet(object, main, context), 2);
        List file1 = ArchetypeNodes.removeAll(list, (String[])new String[]{"file", "directory"});
        Property file2 = ArchetypeNodes.remove(list, (String)"fileType");
        grid.add(this.createComponentSet(object, file1, context), 2);
        grid.add(new ComponentState[]{new ComponentState((Component)new Label()), this.createComponent(file2, object, context)});
        List email1 = ArchetypeNodes.removeAll(list, (String[])new String[]{"email", "emailFrom"});
        Property email2 = ArchetypeNodes.remove(list, (String)"emailTo0");
        Property email3 = ArchetypeNodes.remove(list, (String)"attachmentType");
        grid.add(this.createComponentSet(object, email1, context), 2);
        grid.add(new ComponentState[]{new ComponentState((Component)new Label()), this.createComponent(email2, object, context)});
        grid.add(new ComponentState[]{new ComponentState((Component)new Label()), this.createComponent(email3, object, context)});
        List print = ArchetypeNodes.removeAll(list, (String[])new String[]{"print", "printer"});
        grid.add(this.createComponentSet(object, print, context), 2);
        grid.add(this.createComponentSet(object, list, context), 2);
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{grid.createGrid()}));
    }

    protected void doComplexLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        if (!properties.isEmpty() || this.parameterList != null) {
            IMObjectTabPaneModel model = this.doTabLayout(object, properties, container, context, false);
            IMObjectTabPane pane = new IMObjectTabPane(model);
            if (this.parameterList != null) {
                String label = Messages.get((String)"scheduledreport.parameters");
                model.addTab(label, (Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.parameterList}));
            }
            pane.setSelectedIndex(0);
            container.add((Component)pane);
        }
    }

    private List<Property> getEmailTo(PropertySet properties) {
        Property property;
        ArrayList<Property> result = new ArrayList<Property>();
        int i = 0;
        while ((property = properties.get("emailTo" + i)) != null) {
            result.add(property);
            ++i;
        }
        return result;
    }

    private Component createParameters(PropertySet properties, ArchetypeNodes nodes, LayoutContext context) {
        ArrayList<Property> list;
        Grid result = null;
        if (this.parameters == null) {
            this.parameters = new ParameterComponents(new Parameters(properties), context);
        }
        if (!(list = new ArrayList<Property>(this.parameters.getParameters())).isEmpty()) {
            ComponentSet set = new ComponentSet();
            for (Property parameter : list) {
                this.parameters.exclude(parameter, nodes);
                ComponentState component = this.parameters.getComponent(parameter);
                if (component == null) continue;
                set.add(component);
            }
            ComponentGrid grid = new ComponentGrid();
            grid.add(set, 2);
            result = grid.createGrid();
        }
        return result;
    }
}

