/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentTemplatePrinter;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.report.ParameterType;
import org.openvpms.report.Report;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.UserMailContext;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.SingleEntityLinkCollectionEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.mail.AddressSelector;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.component.mail.FromAddressSelector;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.ToAddressSelector;
import org.openvpms.web.component.print.BoundPrinterField;
import org.openvpms.web.component.print.PrinterListModel;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.job.AbstractJobConfigurationEditor;
import org.openvpms.web.workspace.admin.job.scheduledreport.Parameters;
import org.openvpms.web.workspace.admin.job.scheduledreport.ParametersEditor;
import org.openvpms.web.workspace.admin.job.scheduledreport.ScheduledReportJobConfigurationLayoutStrategy;
import org.openvpms.web.workspace.admin.job.scheduledreport.ScheduledReportTemplateEditor;

public class ScheduledReportJobConfigurationEditor
extends AbstractJobConfigurationEditor {
    public static final String REPORT = "report";
    public static final String FILE = "file";
    public static final String DIRECTORY = "directory";
    public static final String EMAIL = "email";
    public static final String EMAIL_FROM = "emailFrom";
    public static final String EMAIL_TO = "emailTo";
    public static final String PRINT = "print";
    public static final String PRINTER = "printer";
    private final ReportFactory reportFactory = (ReportFactory)ServiceHelper.getBean(ReportFactory.class);
    private final SingleEntityLinkCollectionEditor reportLink;
    private final SelectField printerSelector;
    private final PropertyComponentEditor printerEditor;
    private final Parameters parameters;
    private final int maxEmailTo;
    private final AddressSelector from;
    private final ToAddressSelector to;
    private int emailTo;
    private ParametersEditor parametersEditor;
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";

    public ScheduledReportJobConfigurationEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
        Property toEmail;
        this.reportLink = new SingleEntityLinkCollectionEditor(this.getCollectionProperty(REPORT), object, layoutContext);
        this.reportLink.getComponent();
        MailContext mailContext = layoutContext.getMailContext();
        if (mailContext == null) {
            mailContext = new UserMailContext(layoutContext.getContext());
        }
        ArrayList<Contact> fromContacts = new ArrayList<Contact>(mailContext.getFromAddresses());
        String fromAddress = this.getProperty(EMAIL_FROM).getString();
        Contact fromContact = this.initFromContacts(fromAddress, fromContacts);
        this.from = new FromAddressSelector(fromContacts, mailContext.getFromAddressFormatter());
        this.from.setSelected(fromContact);
        this.from.addModifiableListener(modifiable -> this.getProperty(EMAIL_FROM).setValue((Object)this.from.getNameAddress()));
        ArrayList<String> toAddresses = new ArrayList<String>();
        int emailIndex = 0;
        while ((toEmail = this.getEmailTo(emailIndex)) != null) {
            ++emailIndex;
            String address = toEmail.getString();
            if (StringUtils.isEmpty((CharSequence)address)) continue;
            toAddresses.add(address);
        }
        this.emailTo = toAddresses.size();
        this.maxEmailTo = emailIndex;
        List toContacts = mailContext.getToAddresses().getContacts();
        ArrayList<Contact> selected = new ArrayList<Contact>();
        for (String toAddress : toAddresses) {
            Contact contact = AddressSelector.getContact((List)toContacts, (String)toAddress);
            if (contact != null || (contact = AddressSelector.createContact((String)toAddress)) == null) continue;
            selected.add(contact);
        }
        this.to = new ToAddressSelector(toContacts, mailContext.getToAddressFormatter(), layoutContext, "mail.to");
        this.to.setSelected(selected);
        this.to.addModifiableListener(modifiable -> this.onEmailToSelected());
        Property printer = this.getProperty(PRINTER);
        DocumentTemplate template = this.getTemplate();
        PrinterListModel model = template != null ? this.getPrinters(template) : new PrinterListModel();
        this.printerSelector = new BoundPrinterField(printer, model);
        this.printerEditor = new PropertyComponentEditor(printer, (Component)this.printerSelector);
        this.addEditor((Editor)this.printerEditor);
        this.reportLink.addModifiableListener(modifiable -> this.onReportChanged());
        this.parameters = new Parameters(this.getProperties());
        this.parametersEditor = new ParametersEditor(this.parameters, layoutContext);
    }

    public boolean isModified() {
        return super.isModified() || this.parametersEditor.isModified();
    }

    public void clearModified() {
        super.clearModified();
        this.parametersEditor.clearModified();
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        ScheduledReportJobConfigurationLayoutStrategy strategy = new ScheduledReportJobConfigurationLayoutStrategy(this.parametersEditor.getParameters());
        strategy.addComponent(new ComponentState((PropertyEditor)this.reportLink));
        strategy.addComponent(new ComponentState((PropertyEditor)this.printerEditor));
        strategy.addComponent(new ComponentState(this.from.getComponent(), this.getProperty(EMAIL_FROM)));
        strategy.addComponent(new ComponentState(this.to.getComponent(), this.getEmailTo(0)));
        return strategy;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateSelection(validator) && this.parametersEditor.validate(validator) && this.validateFile(validator) && this.validateEmail(validator) && this.validatePrint(validator);
    }

    private void onEmailToSelected() {
        int i;
        String[] addresses = this.to.getAddresses();
        if (addresses == null) {
            addresses = new String[]{};
        }
        this.emailTo = addresses.length;
        for (i = 0; i < addresses.length && i < this.maxEmailTo; ++i) {
            this.getEmailTo(i).setValue((Object)addresses[i]);
        }
        while (i < this.maxEmailTo) {
            this.getEmailTo(i).setValue(null);
            ++i;
        }
    }

    private Contact initFromContacts(String selected, List<Contact> contacts) {
        EmailAddress address;
        Contact result = null;
        if (!StringUtils.isEmpty((CharSequence)selected) && (result = AddressSelector.getContact(contacts, (String)selected)) == null && (address = EmailAddress.parse((String)selected)) != null) {
            result = AddressSelector.createContact((EmailAddress)address);
            contacts.add(result);
        }
        return result;
    }

    private boolean validateSelection(Validator validator) {
        boolean result = false;
        if (this.isFileSelected() || this.isEmailSelected() || this.isPrintSelected()) {
            result = true;
        } else {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"scheduledreport.nothingselected")));
        }
        return result;
    }

    private void onReportChanged() {
        Set parameterTypes = Collections.emptySet();
        DocumentTemplate template = this.getTemplate();
        if (template != null) {
            this.getProperty(NAME).setValue((Object)template.getName());
            this.getProperty(DESCRIPTION).setValue((Object)template.getDescription());
            if (template.hasDocument()) {
                Report report = this.reportFactory.createReport(template);
                parameterTypes = report.getParameterTypes();
            }
            PrinterListModel model = this.getPrinters(template);
            this.printerSelector.setModel((ListModel)model);
        }
        this.updateParameters(parameterTypes);
        this.onLayout();
    }

    private PrinterListModel getPrinters(DocumentTemplate template) {
        ArrayList<PrinterReference> printers = new ArrayList<PrinterReference>();
        for (DocumentTemplatePrinter printer : template.getPrinters()) {
            PrinterReference reference = printer.getPrinter();
            if (reference == null) continue;
            printers.add(reference);
        }
        PrinterListModel model = !printers.isEmpty() ? new PrinterListModel(printers) : new PrinterListModel();
        return model;
    }

    private DocumentTemplate getTemplate() {
        ScheduledReportTemplateEditor currentEditor = (ScheduledReportTemplateEditor)this.reportLink.getCurrentEditor();
        return currentEditor != null ? currentEditor.getTemplate() : null;
    }

    private void updateParameters(Set<ParameterType> parameterTypes) {
        this.parameters.update(parameterTypes);
        this.parametersEditor.dispose();
        this.parametersEditor = new ParametersEditor(this.parameters, this.getLayoutContext());
    }

    private boolean validateFile(Validator validator) {
        boolean result;
        block9: {
            result = false;
            if (this.isFileSelected()) {
                Property property = this.getProperty(DIRECTORY);
                String pathName = property.getString();
                if (StringUtils.isEmpty((CharSequence)pathName)) {
                    this.reportRequired(property, validator);
                } else {
                    try {
                        Path path = FileSystems.getDefault().getPath(pathName, new String[0]);
                        if (!Files.exists(path, new LinkOption[0])) {
                            validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"dir.notfound", (Object[])new Object[]{pathName})));
                            break block9;
                        }
                        if (!Files.isDirectory(path, new LinkOption[0])) {
                            validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"dir.notdir", (Object[])new Object[]{pathName})));
                            break block9;
                        }
                        if (!Files.isWritable(path)) {
                            validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"dir.notwritable", (Object[])new Object[]{pathName})));
                            break block9;
                        }
                        result = true;
                    }
                    catch (InvalidPathException exception) {
                        validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"dir.invalid", (Object[])new Object[]{pathName})));
                    }
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private boolean isFileSelected() {
        return this.getProperty(FILE).getBoolean();
    }

    private boolean validateEmail(Validator validator) {
        boolean result = false;
        if (this.isEmailSelected()) {
            Property from = this.getProperty(EMAIL_FROM);
            if (StringUtils.isEmpty((CharSequence)from.getString())) {
                this.reportRequired(from, validator);
            } else if (this.emailTo == 0) {
                this.reportRequired(this.getEmailTo(0), validator);
            } else if (this.emailTo > this.maxEmailTo) {
                String message = Messages.format((String)"scheduledreport.toomanyemails", (Object[])new Object[]{this.emailTo, this.maxEmailTo});
                validator.add((Modifiable)this, new ValidatorError(message));
            } else {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean isEmailSelected() {
        return this.getProperty(EMAIL).getBoolean();
    }

    private boolean validatePrint(Validator validator) {
        boolean result = false;
        if (this.isPrintSelected()) {
            Property printer = this.getProperty(PRINTER);
            if (StringUtils.isEmpty((CharSequence)printer.getString())) {
                this.reportRequired(printer, validator);
            } else {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean isPrintSelected() {
        return this.getProperty(PRINT).getBoolean();
    }

    private Property getEmailTo(int index) {
        return this.getProperty(EMAIL_TO + index);
    }
}

