/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job.scheduledreport;

import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.edit.DefaultEditableComponentFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.job.scheduledreport.ParameterComponents;
import org.openvpms.web.workspace.admin.job.scheduledreport.Parameters;

class ParametersEditor
extends AbstractModifiable {
    private final Parameters parameters;
    private final ParameterComponents components;
    private Editors editors = new Editors();

    public ParametersEditor(Parameters parameters, LayoutContext context) {
        this.parameters = parameters;
        context = new DefaultLayoutContext(context);
        context.setComponentFactory((IMObjectComponentFactory)new DefaultEditableComponentFactory(context));
        this.components = new ParameterComponents(parameters, context);
        for (Editor editor : this.components.getEditors()) {
            this.editors.add(editor);
        }
    }

    public ParameterComponents getParameters() {
        return this.components;
    }

    public boolean isModified() {
        return this.editors.isModified();
    }

    public void clearModified() {
        this.editors.clearModified();
    }

    public void addModifiableListener(ModifiableListener listener) {
        this.editors.addModifiableListener(listener);
    }

    public void addModifiableListener(ModifiableListener listener, int index) {
        this.editors.addModifiableListener(listener, index);
    }

    public void removeModifiableListener(ModifiableListener listener) {
        this.editors.removeModifiableListener(listener);
    }

    public void setErrorListener(ErrorListener listener) {
        this.editors.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.editors.getErrorListener();
    }

    public void dispose() {
        this.editors.dispose();
    }

    protected boolean doValidation(Validator validator) {
        return this.editors.validate(validator) && this.validateParameters(validator);
    }

    private boolean validateParameters(Validator validator) {
        int maxParameters;
        boolean result = false;
        int count = this.parameters.getParameterCount();
        if (count <= (maxParameters = this.parameters.getMaxParameters())) {
            result = true;
        } else {
            String message = Messages.format((String)"scheduledreport.toomanyparameters", (Object[])new Object[]{count, maxParameters});
            validator.add((Modifiable)this, new ValidatorError(message));
        }
        return result;
    }
}

