/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import java.util.Date;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.service.scheduler.JobScheduler;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;

public class JobCRUDWindow
extends ResultSetCRUDWindow<Entity> {
    private static final String RUN_ID = "button.run";

    public JobCRUDWindow(Archetypes<Entity> archetypes, Query<Entity> query, ResultSet<Entity> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(RUN_ID, this::onRun);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(RUN_ID, enable);
    }

    protected void onRun() {
        Entity object = (Entity)this.getObject();
        final Entity config = (Entity)IMObjectHelper.reload((IMObject)object);
        if (config != null) {
            final JobScheduler scheduler = (JobScheduler)ServiceHelper.getBean(JobScheduler.class);
            String title = Messages.get((String)"admin.job.run.title");
            if (!config.isActive()) {
                InformationDialog.show((String)title, (String)Messages.format((String)"admin.job.run.inactive", (Object[])new Object[]{config.getName()}));
            } else {
                Date run = scheduler.getNextRunTime(config);
                String scheduled = run != null ? DateFormatter.formatDateTimeAbbrev((Date)run) : Messages.get((String)"admin.job.run.never");
                String message = Messages.format((String)"admin.job.run.message", (Object[])new Object[]{config.getName(), scheduled});
                ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                    public void onYes() {
                        scheduler.run(config);
                    }
                });
            }
        } else {
            this.onRefresh((IMObject)object);
        }
    }
}

