/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.job.AbstractJobConfigurationEditor;
import org.springframework.util.StringUtils;

public class DocumentLoaderJobConfigurationEditor
extends AbstractJobConfigurationEditor {
    public DocumentLoaderJobConfigurationEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateDirs(validator) && this.validateIdPattern(validator) && this.validateArchetypes(validator);
    }

    private boolean validateDirs(Validator validator) {
        File errorDir;
        boolean result = false;
        Property source = this.getProperty("sourceDir");
        Property target = this.getProperty("targetDir");
        Property error = this.getProperty("errorDir");
        File sourceDir = new File(source.getString());
        File targetDir = new File(target.getString());
        File file = errorDir = error.getString() != null ? new File(error.getString()) : null;
        if (this.validateDir(source, sourceDir, validator) && this.validateDir(target, targetDir, validator) && (errorDir == null || this.validateDir(error, errorDir, validator))) {
            if (sourceDir.equals(targetDir)) {
                String message = Messages.format((String)"docload.dir.samedirs", (Object[])new Object[]{source.getDisplayName(), target.getDisplayName()});
                validator.add((Modifiable)this, new ValidatorError(message));
            } else if (errorDir != null && sourceDir.equals(errorDir)) {
                String message = Messages.format((String)"docload.dir.samedirs", (Object[])new Object[]{source.getDisplayName(), error.getDisplayName()});
                validator.add((Modifiable)this, new ValidatorError(message));
            } else {
                result = true;
            }
        }
        return result;
    }

    private boolean validateDir(Property property, File file, Validator validator) {
        boolean valid = false;
        if (!file.exists()) {
            validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"dir.notfound", (Object[])new Object[]{file.getPath()})));
        } else if (!file.isDirectory()) {
            validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"dir.notdir", (Object[])new Object[]{file.getPath()})));
        } else {
            valid = true;
        }
        return valid;
    }

    private boolean validateIdPattern(Validator validator) {
        boolean result = false;
        Property property = this.getProperty("idPattern");
        String pattern = property.getString();
        try {
            Pattern.compile(pattern);
            result = true;
        }
        catch (PatternSyntaxException exception) {
            validator.add((Modifiable)property, new ValidatorError(property, exception.getMessage()));
        }
        return result;
    }

    private boolean validateArchetypes(Validator validator) {
        boolean result = true;
        Property property = this.getProperty("archetypes");
        String[] shortNames = property.getString("archetypes").split(",");
        block0: for (String shortName : shortNames = StringUtils.trimArrayElements((String[])shortNames)) {
            List descriptors = DescriptorHelper.getArchetypeDescriptors((String)shortName, (ArchetypeService)ServiceHelper.getArchetypeService());
            if (descriptors.isEmpty()) {
                validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"docload.archetype.notfound", (Object[])new Object[]{shortName})));
                result = false;
                break;
            }
            for (ArchetypeDescriptor descriptor : descriptors) {
                String archetype = descriptor.getArchetypeType();
                if (!"act.documentTemplate".equals(archetype) && DocumentAct.class.isAssignableFrom(descriptor.getClassType()) && descriptor.getNodeDescriptor("document") != null) continue;
                validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"docload.archetype.invalid", (Object[])new Object[]{archetype})));
                result = false;
                continue block0;
            }
        }
        return result;
    }
}

