/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.job;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.job.SingletonJobConfigurationEditor;

public class AppointmentReminderJobConfigurationEditor
extends SingletonJobConfigurationEditor {
    private static final String SMS_FROM = "smsFrom";
    private static final String SMS_FROM_UNITS = "smsFromUnits";
    private static final String SMS_TO = "smsTo";
    private static final String SMS_TO_UNITS = "smsToUnits";

    public AppointmentReminderJobConfigurationEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateInterval(validator);
    }

    private boolean validateInterval(Validator validator) {
        Date toDate;
        boolean valid = false;
        int from = this.getProperty(SMS_FROM).getInt();
        DateUnits fromUnits = DateUnits.valueOf((String)this.getProperty(SMS_FROM_UNITS).getString());
        int to = this.getProperty(SMS_TO).getInt();
        DateUnits toUnits = DateUnits.valueOf((String)this.getProperty(SMS_TO_UNITS).getString());
        Date now = new Date();
        Date fromDate = DateRules.getDate((Date)now, (int)from, (DateUnits)fromUnits);
        if (DateRules.compareTo((Date)fromDate, (Date)(toDate = DateRules.getDate((Date)now, (int)to, (DateUnits)toUnits))) <= 0) {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"sms.appointment.fromGreaterThanToInterval")));
        } else {
            valid = true;
        }
        return valid;
    }
}

