/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.hl7.LookupMapping;
import org.openvpms.web.workspace.admin.hl7.LookupMappingCSVReader;
import org.openvpms.web.workspace.admin.hl7.LookupMappings;

public class LookupMappingImporter {
    private final ArchetypeService service;
    private final LookupService lookups;
    private final DocumentHandlers handlers;
    private final char separator;

    public LookupMappingImporter(ArchetypeService service, LookupService lookups, DocumentHandlers handlers, char separator) {
        this.service = service;
        this.lookups = lookups;
        this.handlers = handlers;
        this.separator = separator;
    }

    public LookupMappings load(Document document) {
        LookupMappingCSVReader reader = new LookupMappingCSVReader(this.handlers, this.separator);
        LookupMappings mappings = reader.read(document);
        if (mappings.getErrors().isEmpty()) {
            mappings = this.load(mappings);
        }
        return mappings;
    }

    private LookupMappings load(LookupMappings mappings) {
        ArrayList<LookupMapping> success = new ArrayList<LookupMapping>();
        ArrayList<LookupMapping> errors = new ArrayList<LookupMapping>();
        for (LookupMapping mapping : mappings.getMappings()) {
            org.openvpms.component.model.lookup.Lookup from = this.getLookup(mapping.getFromType(), mapping.getFromCode(), mapping.getFromName(), mapping);
            org.openvpms.component.model.lookup.Lookup to = this.getLookup(mapping.getToType(), mapping.getToCode(), mapping.getToName(), mapping);
            if (from == null || to == null) {
                errors.add(mapping);
                break;
            }
            try {
                IMObjectBean bean = this.service.getBean((IMObject)from);
                if (bean.getTargetRefs("mapping").contains(to.getObjectReference())) continue;
                org.openvpms.component.business.domain.im.lookup.LookupRelationship relationship = (org.openvpms.component.business.domain.im.lookup.LookupRelationship)bean.addTarget("mapping", (IMObject)to);
                to.addLookupRelationship((LookupRelationship)relationship);
                this.service.save(Arrays.asList(from, to));
                success.add(mapping);
            }
            catch (Throwable exception) {
                mapping.setError(ErrorFormatter.format((Throwable)exception));
                errors.add(mapping);
                break;
            }
        }
        return new LookupMappings(success, errors);
    }

    private org.openvpms.component.model.lookup.Lookup getLookup(String shortName, String code, String name, LookupMapping mapping) {
        org.openvpms.component.model.lookup.Lookup result = null;
        String[] matches = DescriptorHelper.getShortNames((String)shortName, (ArchetypeService)this.service);
        if (matches.length != 1 || !StringUtils.equals((CharSequence)matches[0], (CharSequence)shortName) || !Objects.equals(this.service.getArchetypeDescriptor(shortName).getClassType(), Lookup.class)) {
            mapping.setError(Messages.format((String)"admin.hl7.mapping.import.invalidArch", (Object[])new Object[]{shortName}));
        } else {
            org.openvpms.component.model.lookup.Lookup lookup = this.lookups.getLookup(shortName, code);
            if (lookup == null) {
                try {
                    lookup = (org.openvpms.component.model.lookup.Lookup)this.service.create(shortName, org.openvpms.component.model.lookup.Lookup.class);
                    lookup.setCode(code);
                    lookup.setName(name);
                    result = lookup;
                }
                catch (OpenVPMSException openVPMSException) {}
            } else if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)lookup.getName())) {
                mapping.setError(Messages.format((String)"admin.hl7.mapping.import.invalidName", (Object[])new Object[]{lookup.getName(), lookup.getCode(), name}));
            } else {
                result = lookup;
            }
        }
        return result;
    }
}

