/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.hl7;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.lookup.LookupService;

public class LookupMappingCSVWriter {
    public static final String[] HEADER = new String[]{"Map From Type", "Map From Code", "Map From Name", "Map To Type", "Map To Code", "Map To Name"};
    private final IArchetypeService service;
    private final LookupService lookups;
    private final DocumentHandlers handlers;
    private final char separator;

    public LookupMappingCSVWriter(IArchetypeService service, LookupService lookups, DocumentHandlers handlers, char separator) {
        this.service = service;
        this.lookups = lookups;
        this.handlers = handlers;
        this.separator = separator;
    }

    public Document write(String name, String from, String to) {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer, this.separator);
        csv.writeNext(HEADER);
        List<Lookup> fromLookups = this.sort(this.getLookups(from));
        List<Lookup> toLookups = this.sort(this.getLookups(to));
        for (Lookup fromLookup : fromLookups) {
            boolean found = false;
            IMObjectBean bean = this.service.getBean((IMObject)fromLookup);
            for (Reference mapping : bean.getTargetRefs("mapping")) {
                Lookup toLookup;
                if (!mapping.isA(to) || (toLookup = (Lookup)this.service.get(mapping, Lookup.class)) == null) continue;
                this.write(csv, from, fromLookup, to, toLookup);
                toLookups.remove(toLookup);
                found = true;
            }
            if (found) continue;
            this.write(csv, from, fromLookup, to, null);
        }
        for (Lookup toLookup : toLookups) {
            this.write(csv, from, null, to, toLookup);
        }
        DocumentHandler handler = this.handlers.get(name, "text/csv");
        byte[] buffer = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        return handler.create(name, (InputStream)new ByteArrayInputStream(buffer), "text/csv", buffer.length);
    }

    protected Collection<Lookup> getLookups(String shortName) {
        return this.lookups.getLookups(shortName);
    }

    protected List<Lookup> sort(Collection<Lookup> lookups) {
        ArrayList<Lookup> result = new ArrayList<Lookup>(lookups);
        result.sort(Comparator.comparing(Lookup::getCode));
        return result;
    }

    private void write(CSVWriter writer, String from, Lookup fromLookup, String to, Lookup toLookup) {
        String[] line = new String[]{from, this.getCode(fromLookup), this.getName(fromLookup), to, this.getCode(toLookup), this.getName(toLookup)};
        writer.writeNext(line);
        if (writer.checkError()) {
            throw new IllegalStateException("Failed to write lookup mapping");
        }
    }

    private String getName(Lookup lookup) {
        return lookup != null ? lookup.getName() : null;
    }

    private String getCode(Lookup lookup) {
        return lookup != null ? lookup.getCode() : null;
    }
}

